package com.firefly.design.data;

import com.firefly.design.si.Document;
import com.firefly.design.si.Picture;
import lombok.Data;

import java.time.Instant;
import java.util.Map;

@Data
public class DocumentObject {

    private String id;

    private Map<String, String> metadata;

    private Picture cover;

    private Picture preview;

    private Document document;


    private Instant createdAt;

    public static DocumentObject of(Document document) {
        var object = new DocumentObject();
        object.setDocument(document);
        return object;
    }
}
