/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.design.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.firefly.design.data.TemplateStatus;
import com.firefly.design.data.TemplateType;
import com.firefly.design.data.WorkTemplate;
import com.firefly.design.si.DocumentType;
import com.firefly.design.si.Picture;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=WorkTemplate.class, name="WORK"), @JsonSubTypes.Type(value=Template.class, name="BACKGROUND"), @JsonSubTypes.Type(value=Template.class, name="TEXT"), @JsonSubTypes.Type(value=Template.class, name="CLIP_PATH_IMAGE")})
public class Template {
    private String id;
    private String namespace;
    private String title;
    private TemplateType type;
    private List<String> styles;
    private List<String> tags;
    private String description;
    private List<String> keywords;
    private Map<String, String> metadata = new HashMap<String, String>();
    private Picture cover;
    private Picture preview;
    private Integer score;
    private DocumentType doctype;
    private String documentId;
    private TemplateStatus status;
    private Instant createdAt;

    @JsonIgnore
    public String sku() {
        return String.format("TEMPLATE:%s", this.id);
    }

    @JsonIgnore
    public boolean isActive() {
        return this.status == TemplateStatus.ACTIVE;
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTitle() {
        return this.title;
    }

    public TemplateType getType() {
        return this.type;
    }

    public List<String> getStyles() {
        return this.styles;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Picture getCover() {
        return this.cover;
    }

    public Picture getPreview() {
        return this.preview;
    }

    public Integer getScore() {
        return this.score;
    }

    public DocumentType getDoctype() {
        return this.doctype;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public TemplateStatus getStatus() {
        return this.status;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(TemplateType type) {
        this.type = type;
    }

    public void setStyles(List<String> styles) {
        this.styles = styles;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setCover(Picture cover) {
        this.cover = cover;
    }

    public void setPreview(Picture preview) {
        this.preview = preview;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public void setDoctype(DocumentType doctype) {
        this.doctype = doctype;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public void setStatus(TemplateStatus status) {
        this.status = status;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$score = this.getScore();
        Integer other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        TemplateType this$type = this.getType();
        TemplateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<String> this$styles = this.getStyles();
        List<String> other$styles = other.getStyles();
        if (this$styles == null ? other$styles != null : !((Object)this$styles).equals(other$styles)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Picture this$cover = this.getCover();
        Picture other$cover = other.getCover();
        if (this$cover == null ? other$cover != null : !((Object)this$cover).equals(other$cover)) {
            return false;
        }
        Picture this$preview = this.getPreview();
        Picture other$preview = other.getPreview();
        if (this$preview == null ? other$preview != null : !((Object)this$preview).equals(other$preview)) {
            return false;
        }
        DocumentType this$doctype = this.getDoctype();
        DocumentType other$doctype = other.getDoctype();
        if (this$doctype == null ? other$doctype != null : !((Object)this$doctype).equals(other$doctype)) {
            return false;
        }
        String this$documentId = this.getDocumentId();
        String other$documentId = other.getDocumentId();
        if (this$documentId == null ? other$documentId != null : !this$documentId.equals(other$documentId)) {
            return false;
        }
        TemplateStatus this$status = this.getStatus();
        TemplateStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        TemplateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<String> $styles = this.getStyles();
        result = result * 59 + ($styles == null ? 43 : ((Object)$styles).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Picture $cover = this.getCover();
        result = result * 59 + ($cover == null ? 43 : ((Object)$cover).hashCode());
        Picture $preview = this.getPreview();
        result = result * 59 + ($preview == null ? 43 : ((Object)$preview).hashCode());
        DocumentType $doctype = this.getDoctype();
        result = result * 59 + ($doctype == null ? 43 : ((Object)$doctype).hashCode());
        String $documentId = this.getDocumentId();
        result = result * 59 + ($documentId == null ? 43 : $documentId.hashCode());
        TemplateStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "Template(id=" + this.getId() + ", namespace=" + this.getNamespace() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", styles=" + this.getStyles() + ", tags=" + this.getTags() + ", description=" + this.getDescription() + ", keywords=" + this.getKeywords() + ", metadata=" + this.getMetadata() + ", cover=" + this.getCover() + ", preview=" + this.getPreview() + ", score=" + this.getScore() + ", doctype=" + this.getDoctype() + ", documentId=" + this.getDocumentId() + ", status=" + this.getStatus() + ", createdAt=" + this.getCreatedAt() + ")";
    }
}

