package com.firefly.design.data.convert;

import com.firefly.design.si.DocumentType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

import java.util.ArrayList;
import java.util.List;

public class DesignConverters {
    private DesignConverters() {}

    public static List<Converter<?, ?>> getConvertersToRegister() {
        List<Converter<?, ?>> converts = new ArrayList<>();
        converts.add(StringToDocumentTypeConvert.INSTANCE);
        converts.add(DocumentTypeToStringConvert.INSTANCE);
        return converts;
    }

    static enum StringToDocumentTypeConvert implements Converter<String, DocumentType> {
        INSTANCE;

        @Override
        public DocumentType convert(@Nullable String source) {
            return source == null ? null : DocumentType.valueOf(source);
        }
    }

    static enum DocumentTypeToStringConvert implements Converter<DocumentType, String> {
        INSTANCE;

        @Override
        public String convert(@Nullable DocumentType source) {
            return source == null ? null : source.toString();
        }
    }
}
