package com.firefly.design.data;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.firefly.design.si.DocumentType;
import com.firefly.design.si.Picture;
import lombok.Data;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = WorkTemplate.class, name = "WORK"),
        @JsonSubTypes.Type(value = Template.class, name = "BACKGROUND"),
        @JsonSubTypes.Type(value = Template.class, name = "TEXT"),
        @JsonSubTypes.Type(value = Template.class, name = "CLIP_PATH_IMAGE"),
})
@Data
public class Template {

    private String id;

    private String namespace;

    private String title;

    //模板(文字模板，作品模板，元素模板)
    private TemplateType type;

    private List<String> styles;

    private List<String> tags;

    private String description;

    private List<String> keywords;

    private Map<String, String> metadata = new HashMap<>();

    //封面
    private Picture cover;

    private Picture preview;

    //得分
    private Integer score;

    //文档类型
    private DocumentType doctype;

    private String documentId;


    private Instant createdAt;
}
