package com.firefly.design.data;

import com.firefly.design.si.Picture;
import lombok.Data;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class Image {

    private String id;

    private ImageType type;

    private String title;

    private String description;

    private List<String> keywords;

    private Map<String, String> metadata = new HashMap<>();
    //品牌（作者）
    private String brand;

    //套系素材，筛选全套素材
    private String set;

    /**
     * PNG
     * SVG
     * GIF
     */
    private String format;

    private Integer width;

    private Integer height;

    private String url;

    //代表色
    private List<String> dominantColors;

    //SVG格式才生效
    //调色板[变量名，默认值]
    private Map<String, String> palette;


    private Picture preview;


    //得分 分数越高优先级越高
    private Integer score;


    private Instant updatedAt;


    private Instant createdAt;
}
