/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.design.si;

import java.util.Objects;

public class DocumentType {
    private final String type;
    private final String subtype;

    public DocumentType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
    }

    public DocumentType(String type) {
        this(type, null);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public static DocumentType valueOf(String value) {
        return DocumentType.parseDocumentType(value);
    }

    public static DocumentType parseDocumentType(String fullType) {
        int subIndex = fullType.indexOf(47);
        if (subIndex == -1) {
            return new DocumentType(fullType);
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1);
        return new DocumentType(type, subtype);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentType that = (DocumentType)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.subtype, that.subtype);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        if (this.subtype != null) {
            builder.append('/');
            builder.append(this.subtype);
        }
        return builder.toString();
    }
}

