package com.firefly.design.si;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.annotation.TypeAlias;

import java.util.List;

/**
 * 图片-文档
 * - logo设计
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ImageDocument extends Document {

    private Integer width;

    private Integer height;

    //标尺: px mm 等
    private String ruler;

//    private String backgroundColor;

    private Background background;




    private List<Element> elements;

    @Override
    public Dimension dimension() {
        return new Dimension(width, height, ruler);
    }
}
