package com.firefly.design.si;

import com.google.common.base.Strings;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.annotation.TypeAlias;

import java.util.Map;

/**
 * 文档
 * 1.
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class ElementDocument extends Document {

    private Element element;

    @Override
    public Dimension dimension() {
        Map<String, Object> properties = element.getProperties();
        String widthString = (String) properties.get("width");
        String heightString = (String) properties.get("height");
        if (Strings.isNullOrEmpty(widthString) || Strings.isNullOrEmpty(heightString)) {
            return null;
        }
        int width = Integer.parseInt(widthString);
        int height = Integer.parseInt(heightString);
        return new Dimension(width, height);
    }
}
