package com.firefly.design.si;

import org.springframework.lang.Nullable;

import java.io.Serializable;


public class Dimension implements Cloneable, Serializable {

    public int width;
    public int height;


    public @Nullable String ruler;

    public Dimension(int width, int height) {
        this(width, height, null);
    }

    public Dimension(int width, int height, @Nullable String ruler) {
        this.width = width;
        this.height = height;
        this.ruler = ruler;
    }

    public int width() {
        return this.width;
    }
    public int height() {
        return this.height;
    }
    public String ruler() {
        return this.ruler;
    }

    public Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException e) {
            // this shouldn't happen, since we are Cloneable
            throw new InternalError(e);
        }
    }
}
