package com.firefly.design.data.util;

import com.firefly.design.si.Element;
import com.firefly.design.si.ImageDocument;
import com.firefly.design.si.PageDocument;
import com.firefly.design.si.PageLayout;
import com.firefly.design.si.Document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DocumentUtils {

    public static List<String> resolveTexts(Document document) {
        List<Element> elements = Collections.emptyList();
        if (document instanceof ImageDocument imageDocument) {
            elements = imageDocument.getElements();
        }
        if (document instanceof PageDocument pageDocument) {
            elements = new ArrayList<>();
            for (PageLayout layout : pageDocument.getLayouts()) {
                elements.addAll(layout.getElements());
            }
        }
        return resolve(elements, element -> {
            Map<String, Object> properties = element.getProperties();
            if (properties == null) {
                return null;
            }
            return (String) properties.get("text");
        });
    }
    private static <T> List<T> resolve(List<Element> elements, Function<Element, T> function) {
        if (elements == null || elements.size() == 0) {
            return Collections.emptyList();
        }
        List<T> values = new ArrayList<>();
        for (Element element : elements) {
            T value = function.apply(element);
            if (value != null) {
                values.add(value);
            }
            List<Element> children = element.getChildren();
            values.addAll(resolve(children, function));
        }
        return values;
    }
}
