package com.firefly.design.data.configuration;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.firefly.design.si.DocumentType;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;

@AutoConfigureBefore(JacksonAutoConfiguration.class)
@Configuration
public class DesignDataAutoConfiguration {
    @Bean
    public DesignModule designModule() {
        return new DesignModule();
    }

//    @Bean
//    public MongoModule mongoModule() {
//        return new MongoModule();
//    }



    public static class DesignModule extends SimpleModule {

        public DesignModule() {
            super("Design");
            this.addSerializer(DocumentType.class, new ToStringSerializer(DocumentType.class));
            this.addDeserializer(DocumentType.class, new DocumentTypeDeserializer());
        }

        public static class DocumentTypeDeserializer extends FromStringDeserializer<DocumentType> {
            DocumentTypeDeserializer() {
                super(DocumentType.class);
            }

            protected DocumentType _deserialize(String value, DeserializationContext ctxt) throws IOException {
                return DocumentType.valueOf(value);
            }
        }
    }
}
