package com.firefly.design.censor;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.SNSType;
import org.beast.sns.data.CensorPredict;
import org.beast.sns.data.CensorScene;
import org.beast.sns.data.CensorSuggest;
import org.beast.sns.wechat.client.SNSWechatClient;
import org.beast.sns.wechat.data.TextCensor;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

import java.util.concurrent.Future;

@Slf4j
@Service
public class WeappSNSCensorPredicator implements SNSCensorPredictor {

    private SNSWechatClient wechatClient;

    public WeappSNSCensorPredicator(SNSWechatClient wechatClient) {
        this.wechatClient = wechatClient;
    }

    @Override
    public SNSType type() {
        return SNSType.WECHAT_WEAPP;
    }

    public Future<CensorSuggest> censor(CensorContextScene scene, String content) {

        var sns = scene.getSns();
        var weappScene = WeappScene.builder().appid(sns.getAppid()).openid(sns.getOpenid()).build();


        TextCensor censor = new TextCensor();
        censor.setOpenid(weappScene.getOpenid());
        censor.setContent(content);
        censor.setScene(CensorScene.NOTE);
        CensorPredict predict = wechatClient.censorText(weappScene.getAppid(), censor).orElseThrow();
        if (predict.isHit()) {
            log.warn("censor content: {} trigger hint", content);
        }
        return AsyncResult.forValue(predict.getSuggest());

    }
}
