package com.firefly.design.censor;

import lombok.Data;
import org.beast.security.core.SNSIdentity;
import org.beast.security.core.SNSUserToken;
import org.springframework.lang.Nullable;

import java.util.Objects;

@Data
public class CensorContextScene {

    @Nullable
    private SNSIdentity sns;


    public CensorContextScene valueOf(@Nullable SNSUserToken snsUserToken) {
        var scene = new CensorContextScene();
        if (Objects.nonNull(snsUserToken)) {
            var identity = SNSIdentity.valueOf(snsUserToken);
            scene.setSns(identity);
        }
        return scene;
    }
}
