package com.firefly.design.censor;

import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.SNSType;
import org.beast.sns.bytedance.client.SNSBytedanceClient;
import org.beast.sns.bytedance.client.dto.CensorTextInput;
import org.beast.sns.data.CensorSuggest;
import org.springframework.scheduling.annotation.AsyncResult;

import java.util.concurrent.Future;

@Slf4j
public class ByteappSNSCensorPredictor implements SNSCensorPredictor{

    private SNSBytedanceClient bytedanceClient;

    public ByteappSNSCensorPredictor(SNSBytedanceClient bytedanceClient) {
        this.bytedanceClient = bytedanceClient;
    }


    @Override
    public SNSType type() {
        return SNSType.BYTEDANCE_BYTEAPP;
    }

    @Override
    public Future<CensorSuggest> censor(CensorContextScene scene, String content) {
        var sns = scene.getSns();
        var byteappScene = ByteappScene.builder().appid(sns.getAppid()).openid(sns.getOpenid()).build();

        CensorTextInput input=  new CensorTextInput();
        input.setContent(content);
        var predict = bytedanceClient.censorText(byteappScene.getAppid(), input).orElseThrow();
        if (predict.isHit()) {
            log.warn("censor content: {} trigger hint", content);
        }
        return AsyncResult.forValue(predict.hit ? CensorSuggest.PASS : CensorSuggest.RICKY);
    }
}
