package com.firefly.design.censor.configuration;

import com.firefly.design.censor.ByteappSNSCensorPredictor;
import com.firefly.design.censor.CensorPredictor;
import com.firefly.design.censor.SNSCensorPredictor;
import com.firefly.design.censor.WeappSNSCensorPredicator;
import org.beast.sns.bytedance.client.SNSBytedanceClient;
import org.beast.sns.wechat.client.SNSWechatClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;




@Configuration
public class CensorAutoConfiguration {


    @ConditionalOnBean(SNSWechatClient.class)
    @Bean
    public WeappSNSCensorPredicator weappSNSCensorPredicator(SNSWechatClient client) {
        return new WeappSNSCensorPredicator(client);
    }

    @ConditionalOnBean(SNSWechatClient.class)
    @Bean
    public ByteappSNSCensorPredictor byteappSNSCensorPredictor(SNSBytedanceClient client) {
        return new ByteappSNSCensorPredictor(client);
    }

    @Bean
    public CensorPredictor censorPredictor(ObjectProvider<SNSCensorPredictor> predictorsObjectProvider) {
        return new CensorPredictor(predictorsObjectProvider.stream());
    }

}
