package com.firefly.design.censor;


import lombok.extern.slf4j.Slf4j;
import org.beast.security.core.SNSIdentity;
import org.beast.security.core.SNSType;
import org.beast.sns.data.CensorSuggest;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Slf4j
public class CensorPredictor {


    private Map<SNSType, SNSCensorPredictor> censorPredictorMap;

    public CensorPredictor(Stream<SNSCensorPredictor> predictors) {

        censorPredictorMap = predictors.collect(Collectors.toMap(
            SNSCensorPredictor::type,
            predictor -> {
                return predictor;
            }
        ));
    }


    @Async
    public Future<CensorSuggest> censor(CensorContextScene scene, String content) {
        if (Objects.isNull(scene)) {
            return new AsyncResult<>(CensorSuggest.PASS);
        }
        SNSIdentity sns = scene.getSns();
        if (Objects.nonNull(sns)) {
            SNSType snsType = sns.getType();
            var predictor = censorPredictorMap.get(snsType);
            if (Objects.isNull(predictor)) {
                throw new IllegalStateException("sns type: " + snsType);
            }
            Future<CensorSuggest> future = predictor.censor(scene, content);
            if (Objects.nonNull(future)) {
                return future;
            }
        }
        return new AsyncResult<>(CensorSuggest.PASS);
    }
}
