/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.answer.client;

import com.firefly.answer.client.dto.Question;
import com.firefly.answer.client.dto.QuestionQueryInput;
import com.firefly.answer.client.dto.QuestionReply;
import java.util.List;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value="firefly-answer")
public interface AnswerClient {
    @GetMapping(value={"/api/questions"})
    public ReturnResult<List<Question>> queryQuestionsBy(@SpringQueryMap QuestionQueryInput var1);

    @PostMapping(value={"/api/questions"})
    public ReturnResult<Question> postQuestion(@RequestBody Question var1);

    @GetMapping(value={"/api/questions/{id}"})
    public ReturnResult<Question> getQuestionById(@PathVariable String var1);

    @PutMapping(value={"/api/questions/{id}"})
    public ReturnResult<Question> putQuestionById(@PathVariable String var1, @RequestBody Question var2);

    @DeleteMapping(value={"/api/questions/{id}"})
    public ReturnResult deleteQuestionById(@PathVariable String var1);

    @PostMapping(value={"/api/questions/{id}/reply"})
    public ReturnResult<QuestionReply> postReplyToQuestionId(@PathVariable String var1, @RequestBody QuestionReply var2);

    @GetMapping(value={"/api/question-replies"})
    public ReturnResult<List<QuestionReply>> queryQuestionRepliesBy();

    @PostMapping(value={"/api/question-replies"})
    public ReturnResult<QuestionReply> postQuestionReply(@RequestBody QuestionReply var1);

    @GetMapping(value={"/api/question-replies/{id}"})
    public ReturnResult<QuestionReply> getQuestionReplyById(@PathVariable String var1);

    @DeleteMapping(value={"/api/question-replies/{id}"})
    public ReturnResult deleteQuestionReplyById(@PathVariable String var1);
}

