package com.firefly.answer.client;

import com.firefly.answer.client.dto.Question;
import com.firefly.answer.client.dto.QuestionQueryInput;
import com.firefly.answer.client.dto.QuestionReply;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("firefly-answer")
public interface AnswerClient {

    @GetMapping("/api/questions")
    ReturnResult<List<Question>> queryQuestionsBy(@SpringQueryMap QuestionQueryInput input);

    @PostMapping("/api/questions")
    ReturnResult<Question> postQuestion(@RequestBody Question input);

    @GetMapping("/api/questions/{id}")
    ReturnResult<Question> getQuestionById(@PathVariable String id);

    @PutMapping("/api/questions/{id}")
    ReturnResult<Question> putQuestionById(@PathVariable String id, @RequestBody Question input);

    @DeleteMapping("/api/questions/{id}")
    ReturnResult deleteQuestionById(@PathVariable String id);


    @GetMapping("/api/question-replies")
    ReturnResult<List<QuestionReply>> queryQuestionRepliesBy();

    @PostMapping("/api/question-replies")
    ReturnResult<QuestionReply> postQuestionReply(@RequestBody QuestionReply input);

    @GetMapping("/api/question-replies/{id}")
    ReturnResult<QuestionReply> getQuestionReplyById(@PathVariable String id);

    @DeleteMapping("/api/question-replies/{id}")
    ReturnResult deleteQuestionReplyById(@PathVariable String id);
}
