/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.ser;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.ser.ArrayWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.AvroWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.KeyValueContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;

public final class MapWriteContext
extends KeyValueContext {
    protected final Map<String, Object> _data = new HashMap<String, Object>();

    public MapWriteContext(AvroWriteContext parent, AvroGenerator generator, Schema schema) {
        super(parent, generator, schema);
    }

    @Override
    public Object rawValue() {
        return this._data;
    }

    @Override
    public final boolean writeFieldName(String name) {
        this._currentName = name;
        this._expectValue = true;
        return true;
    }

    @Override
    public final AvroWriteContext createChildArrayContext() {
        this._verifyValueWrite();
        ArrayWriteContext child = new ArrayWriteContext(this, this._generator, this._createArray(this._schema.getElementType()));
        this._data.put(this._currentName, ((AvroWriteContext)child).rawValue());
        return child;
    }

    @Override
    public final AvroWriteContext createChildObjectContext() throws JsonMappingException {
        this._verifyValueWrite();
        AvroWriteContext child = this._createObjectContext(this._schema.getValueType());
        this._data.put(this._currentName, child.rawValue());
        return child;
    }

    @Override
    public void writeValue(Object value) {
        this._verifyValueWrite();
        this._data.put(this._currentName, value);
    }

    @Override
    public void writeString(String value) {
        this._verifyValueWrite();
        this._data.put(this._currentName, value);
    }

    protected final void _verifyValueWrite() {
        if (!this._expectValue) {
            throw new IllegalStateException("Expecting FIELD_NAME, not value");
        }
        this._expectValue = false;
    }
}

