/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.ser;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.ser.MapWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.ObjectWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.RootContext;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;

public abstract class AvroWriteContext
extends JsonStreamContext {
    protected final AvroWriteContext _parent;
    protected final AvroGenerator _generator;
    protected final Schema _schema;

    protected AvroWriteContext(int type, AvroWriteContext parent, AvroGenerator generator, Schema schema) {
        this._type = type;
        this._parent = parent;
        this._generator = generator;
        this._schema = schema;
    }

    public static AvroWriteContext createRootContext(AvroGenerator generator, Schema schema) {
        return new RootContext(generator, schema);
    }

    public static AvroWriteContext createNullContext() {
        return NullContext.instance;
    }

    public abstract AvroWriteContext createChildArrayContext() throws JsonMappingException;

    public abstract AvroWriteContext createChildObjectContext() throws JsonMappingException;

    public final AvroWriteContext getParent() {
        return this._parent;
    }

    public String getCurrentName() {
        return null;
    }

    public boolean writeFieldName(String name) throws JsonMappingException {
        return false;
    }

    public abstract void writeValue(Object var1) throws JsonMappingException;

    public abstract void writeString(String var1) throws JsonMappingException;

    public abstract Object rawValue();

    public void complete(BinaryEncoder encoder) throws IOException {
        throw new IllegalStateException("Can not be called on " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean canClose() {
        return true;
    }

    protected abstract void appendDesc(StringBuilder var1);

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        this.appendDesc(sb);
        return sb.toString();
    }

    protected GenericRecord _createRecord(Schema schema) throws JsonMappingException {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.UNION) {
            schema = this._recordOrMapFromUnion(schema);
        }
        if (type == Schema.Type.MAP) {
            throw new IllegalStateException("_createRecord should never be called for elements of type MAP");
        }
        try {
            return new GenericData.Record(schema);
        }
        catch (RuntimeException e) {
            throw new JsonMappingException("Failed to create Record type from " + type, (Throwable)e);
        }
    }

    protected GenericArray<Object> _createArray(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            Schema match = null;
            for (Schema s : schema.getTypes()) {
                if (s.getType() != Schema.Type.ARRAY) continue;
                if (match != null) {
                    throw new IllegalStateException("Multiple Array types, can not figure out which to use for: " + schema);
                }
                match = s;
            }
            if (match == null) {
                throw new IllegalStateException("No Array type found in union type: " + schema);
            }
            schema = match;
        }
        return new GenericData.Array(8, schema);
    }

    protected AvroWriteContext _createObjectContext(Schema schema) throws JsonMappingException {
        if (schema.getType() == Schema.Type.UNION) {
            schema = this._recordOrMapFromUnion(schema);
        }
        if (schema.getType() == Schema.Type.MAP) {
            return new MapWriteContext(this, this._generator, schema);
        }
        return new ObjectWriteContext(this, this._generator, this._createRecord(schema));
    }

    protected Schema _recordOrMapFromUnion(Schema unionSchema) {
        Schema match = null;
        for (Schema s : unionSchema.getTypes()) {
            Schema.Type type = s.getType();
            if (type != Schema.Type.RECORD && type != Schema.Type.MAP) continue;
            if (match != null) {
                throw new IllegalStateException("Multiple Record and/or Map types, can not figure out which to use for: " + unionSchema);
            }
            match = s;
        }
        if (match == null) {
            throw new IllegalStateException("No Record or Map type found in union type: " + unionSchema);
        }
        return match;
    }

    private static final class NullContext
    extends AvroWriteContext {
        public static final NullContext instance = new NullContext();

        private NullContext() {
            super(0, null, null, null);
        }

        @Override
        public Object rawValue() {
            return null;
        }

        @Override
        public final AvroWriteContext createChildArrayContext() {
            this._reportError();
            return null;
        }

        @Override
        public final AvroWriteContext createChildObjectContext() {
            this._reportError();
            return null;
        }

        @Override
        public void writeValue(Object value) {
            this._reportError();
        }

        @Override
        public void writeString(String value) throws JsonMappingException {
            this._reportError();
        }

        @Override
        public void appendDesc(StringBuilder sb) {
            sb.append("?");
        }

        protected void _reportError() {
            throw new IllegalStateException("Can not write Avro output without specifying Schema");
        }
    }
}

