/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroScalarReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;

public final class MapReader
extends AvroStructureReader {
    protected static final int STATE_START = 0;
    protected static final int STATE_NAME = 1;
    protected static final int STATE_VALUE = 2;
    protected static final int STATE_END = 3;
    protected static final int STATE_DONE = 4;
    private final AvroScalarReader _scalarReader;
    private final AvroStructureReader _structureReader;
    protected final BinaryDecoder _decoder;
    protected final AvroParserImpl _parser;
    private String _currentName;
    protected int _state;
    protected long _count;

    public MapReader(AvroScalarReader reader) {
        this(null, reader, null, null, null);
    }

    public MapReader(AvroStructureReader reader) {
        this(null, null, reader, null, null);
    }

    private MapReader(AvroReadContext parent, AvroScalarReader scalarReader, AvroStructureReader structReader, BinaryDecoder decoder, AvroParserImpl parser) {
        super(parent, 2);
        this._scalarReader = scalarReader;
        this._structureReader = structReader;
        this._decoder = decoder;
        this._parser = parser;
    }

    @Override
    public MapReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
        return new MapReader(parent, this._scalarReader, this._structureReader, decoder, parser);
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        switch (this._state) {
            case 0: {
                this._parser.setAvroContext(this);
                this._count = this._decoder.readArrayStart();
                this._state = this._count > 0L ? 1 : 3;
                return JsonToken.START_OBJECT;
            }
            case 1: {
                if ((long)this._index < this._count) {
                    this._state = 2;
                    this._currentName = this._decoder.readString();
                    return JsonToken.FIELD_NAME;
                }
                this._count = this._decoder.arrayNext();
                if (this._count > 0L) {
                    this._index = 0;
                    this._currentName = this._decoder.readString();
                    return JsonToken.FIELD_NAME;
                }
            }
            case 3: {
                this._state = 4;
                this._parser.setAvroContext(this.getParent());
                return JsonToken.END_OBJECT;
            }
            case 2: {
                break;
            }
            default: {
                this.throwIllegalState(this._state);
            }
        }
        this._state = 1;
        ++this._index;
        if (this._scalarReader != null) {
            return this._scalarReader.readValue(this._parser, this._decoder);
        }
        AvroStructureReader r = this._structureReader.newReader(this, this._parser, this._decoder);
        this._parser.setAvroContext(r);
        return r.nextToken();
    }

    @Override
    public String nextFieldName() throws IOException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.FIELD_NAME) {
            return this._currentName;
        }
        return null;
    }

    @Override
    public void appendDesc(StringBuilder sb) {
        sb.append('{');
        if (this._currentName != null) {
            sb.append('\"');
            sb.append(this._currentName);
            sb.append('\"');
        } else {
            sb.append('?');
        }
        sb.append('}');
    }
}

