/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReaderFactory;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;

public class AvroSchema
implements FormatSchema {
    public static final String TYPE_ID = "avro";
    protected static final DecoderFactory DECODER_FACTORY = DecoderFactory.get();
    protected static final EncoderFactory ENCODER_FACTORY = EncoderFactory.get();
    protected static final ThreadLocal<SoftReference<BinaryDecoder>> decoderRecycler = new ThreadLocal();
    protected static final ThreadLocal<SoftReference<BinaryEncoder>> encoderRecycler = new ThreadLocal();
    protected final Schema _avroSchema;
    protected final AtomicReference<AvroStructureReader> _reader = new AtomicReference();

    public AvroSchema(Schema asch) {
        this._avroSchema = asch;
    }

    public String getSchemaType() {
        return TYPE_ID;
    }

    public Schema getAvroSchema() {
        return this._avroSchema;
    }

    public static BinaryDecoder decoder(InputStream in, boolean buffering) {
        SoftReference<BinaryDecoder> ref = decoderRecycler.get();
        BinaryDecoder prev = ref == null ? null : ref.get();
        BinaryDecoder next = buffering ? DECODER_FACTORY.binaryDecoder(in, prev) : DECODER_FACTORY.directBinaryDecoder(in, prev);
        decoderRecycler.set(new SoftReference<BinaryDecoder>(next));
        return next;
    }

    public static BinaryDecoder decoder(byte[] buffer, int offset, int len) {
        BinaryDecoder prev;
        SoftReference<BinaryDecoder> ref = decoderRecycler.get();
        BinaryDecoder binaryDecoder = prev = ref == null ? null : ref.get();
        if (prev != null) {
            return DECODER_FACTORY.binaryDecoder(buffer, offset, len, prev);
        }
        prev = DECODER_FACTORY.binaryDecoder(buffer, offset, len, null);
        decoderRecycler.set(new SoftReference<BinaryDecoder>(prev));
        return prev;
    }

    public static BinaryEncoder encoder(OutputStream out, boolean buffering) {
        SoftReference<BinaryEncoder> ref = encoderRecycler.get();
        BinaryEncoder prev = ref == null ? null : ref.get();
        BinaryEncoder next = buffering ? ENCODER_FACTORY.binaryEncoder(out, prev) : ENCODER_FACTORY.directBinaryEncoder(out, prev);
        encoderRecycler.set(new SoftReference<BinaryEncoder>(next));
        return next;
    }

    public AvroStructureReader getReader() {
        AvroStructureReader r = this._reader.get();
        if (r == null) {
            AvroReaderFactory f = new AvroReaderFactory();
            r = f.createReader(this._avroSchema);
            this._reader.set(r);
        }
        return r;
    }
}

