/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.spring.schedule;

import com.dangdang.ddframe.job.lite.api.JobScheduler;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.spring.namespace.parser.common.AbstractJobConfigurationDto;
import com.dangdang.ddframe.job.lite.spring.schedule.SpringJobFactory;
import com.dangdang.ddframe.job.lite.spring.util.AopTargetUtils;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringJobScheduler
extends JobScheduler
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public SpringJobScheduler(CoordinatorRegistryCenter regCenter, AbstractJobConfigurationDto jobConfigDto, ElasticJobListener[] elasticJobListeners) {
        super(regCenter, jobConfigDto.toLiteJobConfiguration(), SpringJobScheduler.getTargetElasticJobListeners(elasticJobListeners));
    }

    private static ElasticJobListener[] getTargetElasticJobListeners(ElasticJobListener[] elasticJobListeners) {
        ElasticJobListener[] result = new ElasticJobListener[elasticJobListeners.length];
        for (int i = 0; i < elasticJobListeners.length; ++i) {
            result[i] = (ElasticJobListener)AopTargetUtils.getTarget(elasticJobListeners[i]);
        }
        return result;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void prepareEnvironments(Properties props) {
        SpringJobFactory.setApplicationContext(this.applicationContext);
        props.put("org.quartz.scheduler.jobFactory.class", SpringJobFactory.class.getName());
    }
}

