/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.spring.namespace.parser.common;

import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.JobTraceEvent;
import com.dangdang.ddframe.job.event.log.JobEventLogConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import java.beans.ConstructorProperties;

public abstract class AbstractJobConfigurationDto {
    private final String jobName;
    private final String cron;
    private final int shardingTotalCount;
    private String shardingItemParameters;
    private String jobParameter;
    private Boolean failover;
    private Boolean misfire;
    private String description;
    private Boolean monitorExecution;
    private Integer maxTimeDiffSeconds;
    private Integer monitorPort;
    private String jobShardingStrategyClass;
    private Boolean disabled;
    private Boolean overwrite;
    private String executorServiceHandler;
    private String jobExceptionHandler;
    private Boolean logEvent;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String logLevel;

    public LiteJobConfiguration toLiteJobConfiguration() {
        JobCoreConfiguration jobCoreConfig = this.buildJobCoreConfiguration();
        return this.buildLiteJobConfiguration(jobCoreConfig);
    }

    private JobCoreConfiguration buildJobCoreConfiguration() {
        JobCoreConfiguration.Builder jobCoreConfigBuilder = JobCoreConfiguration.newBuilder((String)this.jobName, (String)this.cron, (int)this.shardingTotalCount);
        jobCoreConfigBuilder.shardingItemParameters(this.shardingItemParameters);
        jobCoreConfigBuilder.jobParameter(this.jobParameter);
        if (null != this.failover) {
            jobCoreConfigBuilder.failover(this.failover.booleanValue());
        }
        if (null != this.misfire) {
            jobCoreConfigBuilder.misfire(this.misfire.booleanValue());
        }
        if (null != this.executorServiceHandler) {
            jobCoreConfigBuilder.jobProperties(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER.name(), this.executorServiceHandler);
        }
        if (null != this.jobExceptionHandler) {
            jobCoreConfigBuilder.jobProperties(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER.name(), this.jobExceptionHandler);
        }
        this.buildEventConfiguration(jobCoreConfigBuilder);
        jobCoreConfigBuilder.description(this.description);
        return jobCoreConfigBuilder.build();
    }

    private void buildEventConfiguration(JobCoreConfiguration.Builder jobCoreConfigBuilder) {
        if (null != this.logEvent) {
            jobCoreConfigBuilder.jobEventConfiguration(new JobEventConfiguration[]{new JobEventLogConfiguration()});
        }
        if (null != this.driverClassName && null != this.url && null != this.username && null != this.password && null != this.logLevel) {
            jobCoreConfigBuilder.jobEventConfiguration(new JobEventConfiguration[]{new JobEventRdbConfiguration(this.driverClassName, this.url, this.username, this.password, JobTraceEvent.LogLevel.valueOf((String)this.logLevel))});
        }
    }

    private LiteJobConfiguration buildLiteJobConfiguration(JobCoreConfiguration jobCoreConfig) {
        LiteJobConfiguration.Builder result = LiteJobConfiguration.newBuilder((JobTypeConfiguration)this.toJobConfiguration(jobCoreConfig));
        if (null != this.monitorExecution) {
            result.monitorExecution(this.monitorExecution.booleanValue());
        }
        if (null != this.maxTimeDiffSeconds) {
            result.maxTimeDiffSeconds(this.maxTimeDiffSeconds.intValue());
        }
        if (null != this.monitorPort) {
            result.monitorPort(this.monitorPort.intValue());
        }
        result.jobShardingStrategyClass(this.jobShardingStrategyClass);
        if (null != this.disabled) {
            result.disabled(this.disabled.booleanValue());
        }
        if (null != this.overwrite) {
            result.overwrite(this.overwrite.booleanValue());
        }
        if (null != this.overwrite) {
            result.overwrite(this.overwrite.booleanValue());
        }
        return result.build();
    }

    protected abstract JobTypeConfiguration toJobConfiguration(JobCoreConfiguration var1);

    public void setShardingItemParameters(String shardingItemParameters) {
        this.shardingItemParameters = shardingItemParameters;
    }

    public void setJobParameter(String jobParameter) {
        this.jobParameter = jobParameter;
    }

    public void setFailover(Boolean failover) {
        this.failover = failover;
    }

    public void setMisfire(Boolean misfire) {
        this.misfire = misfire;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMonitorExecution(Boolean monitorExecution) {
        this.monitorExecution = monitorExecution;
    }

    public void setMaxTimeDiffSeconds(Integer maxTimeDiffSeconds) {
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
    }

    public void setMonitorPort(Integer monitorPort) {
        this.monitorPort = monitorPort;
    }

    public void setJobShardingStrategyClass(String jobShardingStrategyClass) {
        this.jobShardingStrategyClass = jobShardingStrategyClass;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setExecutorServiceHandler(String executorServiceHandler) {
        this.executorServiceHandler = executorServiceHandler;
    }

    public void setJobExceptionHandler(String jobExceptionHandler) {
        this.jobExceptionHandler = jobExceptionHandler;
    }

    public void setLogEvent(Boolean logEvent) {
        this.logEvent = logEvent;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @ConstructorProperties(value={"jobName", "cron", "shardingTotalCount"})
    public AbstractJobConfigurationDto(String jobName, String cron, int shardingTotalCount) {
        this.jobName = jobName;
        this.cron = cron;
        this.shardingTotalCount = shardingTotalCount;
    }
}

