/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.spring.namespace.parser.common;

import com.dangdang.ddframe.job.lite.spring.namespace.parser.common.AbstractJobConfigurationDto;
import com.dangdang.ddframe.job.lite.spring.schedule.SpringJobScheduler;
import com.google.common.base.Strings;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractJobBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringJobScheduler.class);
        factory.setInitMethodName("init");
        factory.setDestroyMethodName("shutdown");
        factory.addConstructorArgReference(element.getAttribute("registry-center-ref"));
        factory.addConstructorArgValue((Object)this.createJobConfiguration(element));
        factory.addConstructorArgValue(this.createJobListeners(element));
        return factory.getBeanDefinition();
    }

    private BeanDefinition createJobConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(this.getJobConfigurationDTO());
        String jobName = element.getAttribute("id");
        factory.addConstructorArgValue((Object)jobName);
        factory.addConstructorArgValue((Object)element.getAttribute("cron"));
        factory.addConstructorArgValue((Object)element.getAttribute("sharding-total-count"));
        this.addPropertyValueIfNotEmpty("sharding-item-parameters", "shardingItemParameters", element, factory);
        this.addPropertyValueIfNotEmpty("job-parameter", "jobParameter", element, factory);
        this.addPropertyValueIfNotEmpty("monitor-execution", "monitorExecution", element, factory);
        this.addPropertyValueIfNotEmpty("monitor-port", "monitorPort", element, factory);
        this.addPropertyValueIfNotEmpty("max-time-diff-seconds", "maxTimeDiffSeconds", element, factory);
        this.addPropertyValueIfNotEmpty("failover", "failover", element, factory);
        this.addPropertyValueIfNotEmpty("misfire", "misfire", element, factory);
        this.addPropertyValueIfNotEmpty("job-sharding-strategy-class", "jobShardingStrategyClass", element, factory);
        this.addPropertyValueIfNotEmpty("description", "description", element, factory);
        this.addPropertyValueIfNotEmpty("disabled", "disabled", element, factory);
        this.addPropertyValueIfNotEmpty("overwrite", "overwrite", element, factory);
        this.addPropertyValueIfNotEmpty("executor-service-handler", "executorServiceHandler", element, factory);
        this.addPropertyValueIfNotEmpty("job-exception-handler", "jobExceptionHandler", element, factory);
        this.setEventConfigs(element, factory);
        this.setPropertiesValue(element, factory);
        return factory.getBeanDefinition();
    }

    protected abstract Class<? extends AbstractJobConfigurationDto> getJobConfigurationDTO();

    protected abstract void setPropertiesValue(Element var1, BeanDefinitionBuilder var2);

    private List<BeanDefinition> createJobListeners(Element element) {
        BeanDefinitionBuilder factory;
        Element listenerElement = DomUtils.getChildElementByTagName((Element)element, (String)"listener");
        Element distributedListenerElement = DomUtils.getChildElementByTagName((Element)element, (String)"distributed-listener");
        ManagedList result = new ManagedList(2);
        if (null != listenerElement) {
            factory = BeanDefinitionBuilder.rootBeanDefinition((String)listenerElement.getAttribute("class"));
            factory.setScope("prototype");
            result.add(factory.getBeanDefinition());
        }
        if (null != distributedListenerElement) {
            factory = BeanDefinitionBuilder.rootBeanDefinition((String)distributedListenerElement.getAttribute("class"));
            factory.setScope("prototype");
            factory.addConstructorArgValue((Object)distributedListenerElement.getAttribute("started-timeout-milliseconds"));
            factory.addConstructorArgValue((Object)distributedListenerElement.getAttribute("completed-timeout-milliseconds"));
            result.add(factory.getBeanDefinition());
        }
        return result;
    }

    private void setEventConfigs(Element element, BeanDefinitionBuilder factory) {
        Element eventRdbElement = DomUtils.getChildElementByTagName((Element)element, (String)"event-rdb");
        if (null != eventRdbElement) {
            factory.addPropertyValue("driverClassName", (Object)eventRdbElement.getAttribute("driver"));
            factory.addPropertyValue("url", (Object)eventRdbElement.getAttribute("url"));
            factory.addPropertyValue("username", (Object)eventRdbElement.getAttribute("username"));
            factory.addPropertyValue("password", (Object)eventRdbElement.getAttribute("password"));
            factory.addPropertyValue("logLevel", (Object)eventRdbElement.getAttribute("log-level"));
        }
        factory.addPropertyValue("logEvent", (Object)(DomUtils.getChildElementByTagName((Element)element, (String)"event-log") != null ? 1 : 0));
    }

    private void addPropertyValueIfNotEmpty(String attributeName, String propertyName, Element element, BeanDefinitionBuilder factory) {
        String attributeValue = element.getAttribute(attributeName);
        if (!Strings.isNullOrEmpty((String)attributeValue)) {
            factory.addPropertyValue(propertyName, (Object)attributeValue);
        }
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

