/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.EnumBasedResourceQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.KeyboardState;
import com.android.resources.ResourceEnum;

public final class KeyboardStateQualifier
extends EnumBasedResourceQualifier {
    public static final String NAME = "Keyboard State";
    private KeyboardState mValue = null;

    public KeyboardStateQualifier() {
    }

    public KeyboardStateQualifier(KeyboardState value) {
        this.mValue = value;
    }

    public KeyboardState getValue() {
        return this.mValue;
    }

    @Override
    ResourceEnum getEnumValue() {
        return this.mValue;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return "Keyboard";
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        KeyboardState orientation = KeyboardState.getEnum((String)value);
        if (orientation != null) {
            KeyboardStateQualifier qualifier = new KeyboardStateQualifier();
            qualifier.mValue = orientation;
            config.setKeyboardStateQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        if (qualifier instanceof KeyboardStateQualifier) {
            KeyboardStateQualifier referenceQualifier = (KeyboardStateQualifier)qualifier;
            if (referenceQualifier.mValue == KeyboardState.SOFT && this.mValue == KeyboardState.EXPOSED) {
                return true;
            }
            return referenceQualifier.mValue == this.mValue;
        }
        return false;
    }

    @Override
    public boolean isBetterMatchThan(ResourceQualifier compareTo, ResourceQualifier reference) {
        if (compareTo == null) {
            return true;
        }
        KeyboardStateQualifier compareQualifier = (KeyboardStateQualifier)compareTo;
        KeyboardStateQualifier referenceQualifier = (KeyboardStateQualifier)reference;
        return referenceQualifier.mValue == KeyboardState.SOFT && compareQualifier.mValue == KeyboardState.EXPOSED && this.mValue == KeyboardState.SOFT;
    }
}

