/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.sink.entry.group;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.sink.entry.group.TimelineBarrier;
import com.alibaba.otter.canal.store.model.Event;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class TimelineTransactionBarrier
extends TimelineBarrier {
    private ThreadLocal<Boolean> inTransaction = new ThreadLocal(){

        protected Object initialValue() {
            return false;
        }
    };
    private AtomicInteger txState = new AtomicInteger(0);

    public TimelineTransactionBarrier(int groupSize) {
        super(groupSize);
    }

    @Override
    public void await(Event event) throws InterruptedException {
        try {
            super.await(event);
        }
        catch (InterruptedException e) {
            this.reset();
            throw e;
        }
    }

    @Override
    public void await(Event event, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            super.await(event, timeout, unit);
        }
        catch (InterruptedException e) {
            this.reset();
            throw e;
        }
    }

    @Override
    public void clear(Event event) {
        super.clear(event);
        if (this.isTransactionEnd(event)) {
            this.inTransaction.set(false);
            this.txState.compareAndSet(1, 0);
        } else if (this.txState.intValue() == 2) {
            this.txState.compareAndSet(2, 0);
        }
    }

    @Override
    protected boolean isPermit(Event event, long state) {
        boolean result;
        if (this.txState.intValue() == 1 && this.inTransaction.get().booleanValue()) {
            return true;
        }
        if (this.txState.intValue() == 0 && (result = super.isPermit(event, state))) {
            if (this.isTransactionBegin(event)) {
                if (this.txState.compareAndSet(0, 1)) {
                    this.inTransaction.set(true);
                    return true;
                }
            } else if (this.txState.compareAndSet(0, 2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.reset();
    }

    private void reset() {
        this.inTransaction.remove();
        this.txState.set(0);
    }

    private boolean isTransactionBegin(Event event) {
        return event.getEntry().getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN;
    }

    private boolean isTransactionEnd(Event event) {
        return event.getEntry().getEntryType() == CanalEntry.EntryType.TRANSACTIONEND;
    }
}

