/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.sink.entry.group;

import com.alibaba.otter.canal.sink.entry.EntryEventSink;
import com.alibaba.otter.canal.sink.entry.group.GroupBarrier;
import com.alibaba.otter.canal.sink.entry.group.TimelineBarrier;
import com.alibaba.otter.canal.sink.entry.group.TimelineTransactionBarrier;
import com.alibaba.otter.canal.store.model.Event;
import java.util.Arrays;
import java.util.List;

public class GroupEventSink
extends EntryEventSink {
    private int groupSize;
    private GroupBarrier barrier;

    public GroupEventSink() {
        this(1);
    }

    public GroupEventSink(int groupSize) {
        this.groupSize = groupSize;
    }

    @Override
    public void start() {
        super.start();
        this.barrier = this.filterTransactionEntry ? new TimelineBarrier(this.groupSize) : new TimelineTransactionBarrier(this.groupSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSink(List<Event> events) {
        int size = events.size();
        for (int i = 0; i < events.size(); ++i) {
            Event event = events.get(i);
            try {
                this.barrier.await(event);
                if (this.filterTransactionEntry) {
                    boolean bl = super.doSink(Arrays.asList(event));
                    return bl;
                }
                if (i != size - 1) continue;
                boolean bl = super.doSink(events);
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.barrier.clear(event);
            }
        }
        return false;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.barrier.interrupt();
    }
}

