/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.socket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class SocketChannel {
    private Channel channel = null;
    private Object lock = new Object();
    private ByteBuf cache = PooledByteBufAllocator.DEFAULT.directBuffer(0x500000);

    public Channel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannel(Channel channel, boolean notify) {
        this.channel = channel;
        if (notify) {
            SocketChannel socketChannel = this;
            synchronized (socketChannel) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCache(ByteBuf buf) {
        Object object = this.lock;
        synchronized (object) {
            this.cache.discardReadBytes();
            this.cache.writeBytes(buf);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    public void writeChannel(byte[] ... buf) throws IOException {
        if (this.channel == null || !this.channel.isWritable()) {
            throw new IOException("write  failed  !  please checking !");
        }
        this.channel.writeAndFlush((Object)Unpooled.copiedBuffer((byte[][])buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buffer) throws IOException {
        if (null == this.channel) {
            throw new IOException("socket has Interrupted !");
        }
        if (this.cache.readableBytes() < buffer.remaining()) {
            SocketChannel socketChannel = this;
            synchronized (socketChannel) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("socket has Interrupted !");
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.cache.readBytes(buffer);
        }
        return 0;
    }

    public boolean isConnected() {
        return this.channel != null;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.channel != null ? this.channel.remoteAddress() : null;
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
        this.cache.discardReadBytes();
        this.cache.release();
        this.cache = null;
    }
}

