/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.support;

import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.component.FooterComponent;
import com.alibaba.citrus.webx.handler.component.MenuComponent;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import com.alibaba.citrus.webx.handler.support.AutowiredRequestProcessor;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class LayoutRequestProcessor
extends AutowiredRequestProcessor {
    private final Template layoutTemplate = new Template(LayoutRequestProcessor.class.getResource("layout.htm"));
    protected final Template bodyTemplate = new Template(this.getClass().getResource(this.getTemplateName()));
    protected final MenuComponent menuComponent = new MenuComponent(this, "menu");
    protected final FooterComponent footerComponent = new FooterComponent(this, "footer");

    protected final void renderPage(RequestHandlerContext context, String resourceName) throws IOException {
        this.layoutTemplate.accept(new LayoutVisitor(context, "text/html; charset=UTF-8"));
    }

    private String getTemplateName() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("Handler")) {
            name = name.substring(0, name.length() - "Handler".length());
        }
        return StringUtil.toCamelCase(name) + ".htm";
    }

    protected abstract Object getBodyVisitor(RequestHandlerContext var1);

    protected abstract String getTitle(Object var1);

    protected String[] getStyleSheets() {
        return null;
    }

    protected String[] getJavaScripts() {
        return null;
    }

    private class LayoutVisitor
    extends AbstractVisitor {
        private final Object bodyVisitor;
        private final String contentTypeAndCharset;
        private String componentResource;

        public LayoutVisitor(RequestHandlerContext context, String contentTypeAndCharset) throws IOException {
            super(context, contentTypeAndCharset);
            this.contentTypeAndCharset = contentTypeAndCharset;
            this.bodyVisitor = LayoutRequestProcessor.this.getBodyVisitor(context);
        }

        public void visitTitle() {
            ((PrintWriter)this.out()).append(LayoutRequestProcessor.this.getTitle(this.bodyVisitor));
        }

        public void visitContentTypeAndCharset() {
            ((PrintWriter)this.out()).append(this.contentTypeAndCharset);
        }

        public void visitCss(Template cssTemplate) {
            for (String css : LayoutRequestProcessor.this.getComponentResources("css")) {
                this.componentResource = this.context.getResourceURL(css);
                cssTemplate.accept(this);
            }
            String[] pageCss = LayoutRequestProcessor.this.getStyleSheets();
            if (!ArrayUtil.isEmptyArray(pageCss)) {
                for (String css : pageCss) {
                    this.componentResource = this.context.getResourceURL(css);
                    cssTemplate.accept(this);
                }
            }
        }

        public void visitJs(Template jsTemplate) {
            for (String js : LayoutRequestProcessor.this.getComponentResources("js")) {
                this.componentResource = this.context.getResourceURL(js);
                jsTemplate.accept(this);
            }
            String[] pageJs = LayoutRequestProcessor.this.getJavaScripts();
            if (!ArrayUtil.isEmptyArray(pageJs)) {
                for (String js : pageJs) {
                    this.componentResource = this.context.getResourceURL(js);
                    jsTemplate.accept(this);
                }
            }
        }

        public void visitComponentResource() {
            ((PrintWriter)this.out()).append(this.componentResource);
        }

        public void visitMenu() {
            LayoutRequestProcessor.this.menuComponent.visitTemplate(this.context, LayoutRequestProcessor.this.getName());
        }

        public void visitFooter() {
            LayoutRequestProcessor.this.footerComponent.visitTemplate(this.context);
        }

        public void visitBody() {
            LayoutRequestProcessor.this.bodyTemplate.accept(this.bodyVisitor);
        }
    }
}

