/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal.webpagelite;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ServletUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.util.internal.webpagelite.RequestContext;
import com.alibaba.citrus.util.templatelite.Template;
import java.net.URL;

public abstract class PageComponent {
    private final PageComponentRegistry registry;
    private final String componentPath;
    private final String componentName;
    private final Template template;

    public PageComponent(PageComponentRegistry registry, String componentPath) {
        this.registry = Assert.assertNotNull(registry, "pageComponentRegistry", new Object[0]);
        this.componentPath = componentPath = PageComponent.normalizeComponentPath(componentPath);
        registry.register(componentPath, this);
        String className = this.getClass().getSimpleName();
        StringBuilder name = new StringBuilder(className);
        if (className.endsWith("Component")) {
            name.setLength(name.length() - "Component".length());
        }
        Assert.assertTrue(name.length() > 0, "Invalid page component name: %s", className);
        name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        this.componentName = name.toString();
        URL templateResource = Assert.assertNotNull(this.getClass().getResource(name + ".htm"), "Could not find template for page component class: %s", className);
        this.template = new Template(templateResource);
    }

    static String normalizeComponentPath(String componentPath) {
        if ((componentPath = ServletUtil.normalizeURI(componentPath).replaceAll("^/|/$", "") + "/").equals("/")) {
            componentPath = "";
        }
        return componentPath;
    }

    public PageComponentRegistry getRegistry() {
        return this.registry;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Template getTemplate() {
        return this.template;
    }

    public String getComponentURL(RequestContext request, String relativeUrl) {
        return request.getResourceURL(this.getComponentPath() + relativeUrl);
    }
}

