/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.StringUtil;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class ActionEventUtil {
    private static final String EVENT_PATTERN = "eventSubmitDo";
    private static final int EVENT_PATTERN_LENGTH = "eventSubmitDo".length();
    private static final String IMAGE_BUTTON_SUFFIX_1 = ".x";
    private static final String IMAGE_BUTTON_SUFFIX_2 = ".y";
    static final String ACTION_EVENT_KEY = "_action_event_submit_do_";

    public static String getEventName(HttpServletRequest request) {
        Object savedEvent = request.getAttribute(ACTION_EVENT_KEY);
        if (savedEvent != null) {
            if (BasicConstant.NULL_PLACEHOLDER == savedEvent) {
                return null;
            }
            if (savedEvent instanceof String) {
                return (String)savedEvent;
            }
        }
        String event = ActionEventUtil.doGetEventName(request);
        ActionEventUtil.setEventName(request, event);
        return event;
    }

    public static void setEventName(HttpServletRequest request, String eventName) {
        Object savedEvent = StringUtil.trimToNull(eventName);
        if (savedEvent == null) {
            savedEvent = BasicConstant.NULL_PLACEHOLDER;
        }
        request.setAttribute(ACTION_EVENT_KEY, savedEvent);
    }

    private static String doGetEventName(HttpServletRequest request) {
        String event = null;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String originalKey = (String)e.nextElement();
            String paramKey = StringUtil.toCamelCase(originalKey);
            if (paramKey.length() <= EVENT_PATTERN_LENGTH || !paramKey.startsWith(EVENT_PATTERN) || !Character.isUpperCase(paramKey.charAt(EVENT_PATTERN_LENGTH)) || StringUtil.isBlank(request.getParameter(originalKey))) continue;
            int startIndex = EVENT_PATTERN_LENGTH;
            int endIndex = paramKey.length();
            if (paramKey.endsWith(IMAGE_BUTTON_SUFFIX_1)) {
                endIndex -= IMAGE_BUTTON_SUFFIX_1.length();
            } else if (paramKey.endsWith(IMAGE_BUTTON_SUFFIX_2)) {
                endIndex -= IMAGE_BUTTON_SUFFIX_2.length();
            }
            if ((event = StringUtil.uncapitalize(StringUtil.trimToNull(paramKey.substring(startIndex, endIndex)))) == null) continue;
            break;
        }
        return event;
    }
}

