/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.collection;

import com.alibaba.citrus.util.collection.ArrayHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final Object PRESENT = new Object();
    protected transient ArrayHashMap<E, Object> map;
    private static final long serialVersionUID = -5024744406713321676L;

    public ArrayHashSet() {
        this.map = new ArrayHashMap();
    }

    public ArrayHashSet(int initialCapacity) {
        this.map = new ArrayHashMap(initialCapacity);
    }

    public ArrayHashSet(int initialCapacity, float loadFactor) {
        this.map = new ArrayHashMap(initialCapacity, loadFactor);
    }

    public ArrayHashSet(Collection<? extends E> collection) {
        this.map = new ArrayHashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(E object) {
        return this.map.put(object, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    public Object clone() {
        try {
            ArrayHashSet newSet = (ArrayHashSet)super.clone();
            newSet.map = (ArrayHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        int capacity = is.readInt();
        float loadFactor = is.readFloat();
        this.map = new ArrayHashMap(capacity, loadFactor);
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = is.readObject();
            this.map.put(e, PRESENT);
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        os.writeInt(this.map.getCapacity());
        os.writeFloat(this.map.getLoadFactor());
        os.writeInt(this.map.size());
        for (Object e : this.map.keySet()) {
            os.writeObject(e);
        }
    }
}

