/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.collection.ArrayHashMap;
import com.alibaba.citrus.util.collection.ArrayHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    public static <T> ArrayList<T> createArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> createArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <T> ArrayList<T> createArrayList(Iterable<? extends T> c) {
        ArrayList list;
        if (c instanceof Collection) {
            list = new ArrayList((Collection)c);
        } else {
            list = new ArrayList();
            CollectionUtil.iterableToCollection(c, list);
            list.trimToSize();
        }
        return list;
    }

    public static <T, V extends T> ArrayList<T> createArrayList(V ... args) {
        if (args == null || args.length == 0) {
            return new ArrayList();
        }
        ArrayList<V> list = new ArrayList<V>(args.length);
        for (V v : args) {
            list.add(v);
        }
        return list;
    }

    public static <T> LinkedList<T> createLinkedList() {
        return new LinkedList();
    }

    public static <T> LinkedList<T> createLinkedList(Iterable<? extends T> c) {
        LinkedList list = new LinkedList();
        CollectionUtil.iterableToCollection(c, list);
        return list;
    }

    public static <T, V extends T> LinkedList<T> createLinkedList(V ... args) {
        LinkedList<V> list = new LinkedList<V>();
        if (args != null) {
            for (V v : args) {
                list.add(v);
            }
        }
        return list;
    }

    public static <T> List<T> asList(T ... args) {
        if (args == null || args.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(args);
    }

    public static <K, V> HashMap<K, V> createHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> createHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> ArrayHashMap<K, V> createArrayHashMap() {
        return new ArrayHashMap();
    }

    public static <K, V> ArrayHashMap<K, V> createArrayHashMap(int initialCapacity) {
        return new ArrayHashMap(initialCapacity);
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> TreeMap<K, V> createTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> createTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> ConcurrentHashMap<K, V> createConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <T> HashSet<T> createHashSet() {
        return new HashSet();
    }

    public static <T, V extends T> HashSet<T> createHashSet(V ... args) {
        if (args == null || args.length == 0) {
            return new HashSet();
        }
        HashSet<V> set = new HashSet<V>(args.length);
        for (V v : args) {
            set.add(v);
        }
        return set;
    }

    public static <T> HashSet<T> createHashSet(Iterable<? extends T> c) {
        HashSet set;
        if (c instanceof Collection) {
            set = new HashSet((Collection)c);
        } else {
            set = new HashSet();
            CollectionUtil.iterableToCollection(c, set);
        }
        return set;
    }

    public static <T> ArrayHashSet<T> createArrayHashSet() {
        return new ArrayHashSet();
    }

    public static <T, V extends T> ArrayHashSet<T> createArrayHashSet(V ... args) {
        if (args == null || args.length == 0) {
            return new ArrayHashSet();
        }
        ArrayHashSet<V> set = new ArrayHashSet<V>(args.length);
        for (V v : args) {
            set.add(v);
        }
        return set;
    }

    public static <T> ArrayHashSet<T> createArrayHashSet(Iterable<? extends T> c) {
        ArrayHashSet set;
        if (c instanceof Collection) {
            set = new ArrayHashSet((Collection)c);
        } else {
            set = new ArrayHashSet();
            CollectionUtil.iterableToCollection(c, set);
        }
        return set;
    }

    public static <T> LinkedHashSet<T> createLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <T, V extends T> LinkedHashSet<T> createLinkedHashSet(V ... args) {
        if (args == null || args.length == 0) {
            return new LinkedHashSet();
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(args.length);
        for (V v : args) {
            set.add(v);
        }
        return set;
    }

    public static <T> LinkedHashSet<T> createLinkedHashSet(Iterable<? extends T> c) {
        LinkedHashSet set;
        if (c instanceof Collection) {
            set = new LinkedHashSet((Collection)c);
        } else {
            set = new LinkedHashSet();
            CollectionUtil.iterableToCollection(c, set);
        }
        return set;
    }

    public static <T> TreeSet<T> createTreeSet() {
        return new TreeSet();
    }

    public static <T, V extends T> TreeSet<T> createTreeSet(V ... args) {
        return CollectionUtil.createTreeSet(null, args);
    }

    public static <T> TreeSet<T> createTreeSet(Iterable<? extends T> c) {
        return CollectionUtil.createTreeSet(null, c);
    }

    public static <T> TreeSet<T> createTreeSet(Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    public static <T, V extends T> TreeSet<T> createTreeSet(Comparator<? super T> comparator, V ... args) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        if (args != null) {
            for (V v : args) {
                set.add(v);
            }
        }
        return set;
    }

    public static <T> TreeSet<T> createTreeSet(Comparator<? super T> comparator, Iterable<? extends T> c) {
        TreeSet<? super T> set = new TreeSet<T>(comparator);
        CollectionUtil.iterableToCollection(c, set);
        return set;
    }

    public static String join(Iterable<?> objs, String sep) {
        StringBuilder buf = new StringBuilder();
        CollectionUtil.join(buf, objs, sep);
        return buf.toString();
    }

    public static void join(StringBuilder buf, Iterable<?> objs, String sep) {
        try {
            CollectionUtil.join((Appendable)buf, objs, sep);
        }
        catch (IOException e) {
            Assert.unexpectedException(e);
        }
    }

    public static void join(Appendable buf, Iterable<?> objs, String sep) throws IOException {
        if (objs == null) {
            return;
        }
        if (sep == null) {
            sep = "";
        }
        Iterator<?> i = objs.iterator();
        while (i.hasNext()) {
            buf.append(String.valueOf(i.next()));
            if (!i.hasNext()) continue;
            buf.append(sep);
        }
    }

    private static <T> void iterableToCollection(Iterable<? extends T> c, Collection<T> list) {
        for (T element : c) {
            list.add(element);
        }
    }
}

