/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.pipeline.valve.AbstractInputOutputValve;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RenderResultAsJsonValve
extends AbstractInputOutputValve {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final String DEFAULT_JAVASCRIPT_VARIABLE = null;
    private static final String DEFAULT_JAVASCRIPT_CONTENT_TYPE = "application/javascript";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    private String contentType;
    private String javascriptVariable;
    private String javascriptContentType;

    public String getContentType() {
        return this.contentType == null ? DEFAULT_CONTENT_TYPE : this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = StringUtil.trimToNull(contentType);
    }

    public String getJavascriptVariable() {
        return this.javascriptVariable == null ? DEFAULT_JAVASCRIPT_VARIABLE : this.javascriptVariable;
    }

    public void setJavascriptVariable(String javascriptVariable) {
        this.javascriptVariable = StringUtil.trimToNull(javascriptVariable);
    }

    public String getJavascriptContentType() {
        return this.javascriptContentType == null ? DEFAULT_JAVASCRIPT_CONTENT_TYPE : this.javascriptContentType;
    }

    public void setJavascriptContentType(String javascriptContentType) {
        this.javascriptContentType = StringUtil.trimToNull(javascriptContentType);
    }

    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request);
        if (!rundata.isRedirected()) {
            boolean outputAsJson;
            Object resultObject = this.consumeInputValue(pipelineContext);
            if (resultObject == null) {
                return;
            }
            String javascriptVariable = this.getJavascriptVariable();
            boolean bl = outputAsJson = javascriptVariable == null;
            if (outputAsJson) {
                this.response.setContentType(this.getContentType());
            } else {
                this.response.setContentType(this.getJavascriptContentType());
            }
            PrintWriter out = this.response.getWriter();
            String jsonResult = JSON.toJSONString((Object)resultObject);
            if (outputAsJson) {
                out.print(jsonResult);
            } else {
                out.print("var ");
                out.print(javascriptVariable);
                out.print(" = ");
                out.print(jsonResult);
                out.print(";");
            }
        }
        pipelineContext.invokeNext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValveDefinitionParser<RenderResultAsJsonValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "input", "contentType", "javascriptVariable", "javascriptContentType");
        }
    }
}

