/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.auth.impl;

import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.auth.impl.AuthGrant;
import com.alibaba.citrus.turbine.auth.impl.AuthMatch;
import com.alibaba.citrus.turbine.auth.impl.PageAuthorizationServiceImpl;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageAuthorizationServiceDefinitionParser
extends AbstractNamedBeanDefinitionParser<PageAuthorizationServiceImpl> {
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
        String defaultValue = StringUtil.trimToNull(element.getAttribute("default"));
        if (defaultValue != null) {
            boolean allowByDefault = "allow".equals(defaultValue);
            builder.addPropertyValue("allowByDefault", (Object)allowByDefault);
        }
        DomUtil.ElementSelector matchSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("match"));
        List<Object> matches = SpringExtUtil.createManagedList(element, parserContext);
        for (Element matchElement : DomUtil.subElements(element, matchSelector)) {
            matches.addAll(this.parseMatch(matchElement, parserContext));
        }
        builder.addPropertyValue("matches", matches);
    }

    private Collection<Object> parseMatch(Element element, ParserContext parserContext) {
        String targetStr = Assert.assertNotNull(StringUtil.trimToNull(element.getAttribute("target")), "match without target", new Object[0]);
        String[] targets = StringUtil.split(targetStr, ", ");
        DomUtil.ElementSelector grantSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("grant"));
        List<Object> grants = SpringExtUtil.createManagedList(element, parserContext);
        for (Element grantElement : DomUtil.subElements(element, grantSelector)) {
            grants.add(this.parseGrant(grantElement, parserContext));
        }
        LinkedList<Object> matches = CollectionUtil.createLinkedList();
        for (String target : targets) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AuthMatch.class);
            builder.addConstructorArgValue((Object)target);
            builder.addConstructorArgValue(grants);
            matches.add(builder.getBeanDefinition());
        }
        return matches;
    }

    private Object parseGrant(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AuthGrant.class);
        String[] users = StringUtil.split(element.getAttribute("user"), ", ");
        String[] roles = StringUtil.split(element.getAttribute("role"), ", ");
        builder.addPropertyValue("users", (Object)users);
        builder.addPropertyValue("roles", (Object)roles);
        DomUtil.ElementSelector allowSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("allow"));
        DomUtil.ElementSelector denySelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("deny"));
        List<Object> allows = SpringExtUtil.createManagedList(element, parserContext);
        List<Object> denies = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, DomUtil.or(allowSelector, denySelector))) {
            String action = StringUtil.trimToNull(subElement.getTextContent());
            if (allowSelector.accept(subElement)) {
                allows.add(action);
                continue;
            }
            denies.add(action);
        }
        builder.addPropertyValue("allow", allows);
        builder.addPropertyValue("deny", denies);
        return builder.getBeanDefinition();
    }

    @Override
    protected String getDefaultName() {
        return "pageAuthorizationService";
    }
}

