/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.springext.support.ClasspathResourceResolver;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigurationPointSettings {
    public final ResourceResolver resourceResolver;
    public final String baseLocation;
    public final ClassLoader classLoader;

    ConfigurationPointSettings(ResourceResolver resourceResolver, String configurationPointsLocation) {
        this(null, resourceResolver, configurationPointsLocation);
    }

    ConfigurationPointSettings(ClassLoader classLoader, String configurationPointsLocation) {
        this(classLoader, null, configurationPointsLocation);
    }

    private ConfigurationPointSettings(ClassLoader classLoader, ResourceResolver resourceResolver, String configurationPointsLocation) {
        if (resourceResolver == null) {
            if (classLoader == null) {
                classLoader = ClassUtils.getDefaultClassLoader();
            }
            this.classLoader = classLoader;
            this.resourceResolver = new ClasspathResourceResolver(classLoader);
        } else {
            this.classLoader = null;
            this.resourceResolver = resourceResolver;
        }
        Assert.assertNotNull(configurationPointsLocation, "configurationPointsLocation", new Object[0]);
        this.baseLocation = configurationPointsLocation.substring(0, configurationPointsLocation.lastIndexOf("/") + 1);
    }

    ResourceResolver.Resource getResourceFromRelativeLocation(String relativeLocation, Logger log) {
        String location = this.toAbsoluteLocation(relativeLocation);
        if (log != null) {
            log.trace("Trying to find resource at {}", (Object)location);
        }
        return this.resourceResolver.getResource(location);
    }

    List<ResourceResolver.Resource> getResourcesFromRelativeLocationPattern(String relativeLocationPattern, Logger log) {
        String locationPattern = this.toAbsoluteLocation(relativeLocationPattern);
        if (log != null) {
            log.trace("Trying to find resources at {}", (Object)locationPattern);
        }
        try {
            return CollectionUtil.createArrayList(this.resourceResolver.getResources(locationPattern));
        }
        catch (IOException e) {
            if (log != null) {
                log.warn("Failed to load resources: {}: {}", (Object)relativeLocationPattern, (Object)e);
            }
            return Collections.emptyList();
        }
    }

    private String toAbsoluteLocation(String relativeLocationPattern) {
        return this.baseLocation + Assert.assertNotNull(StringUtil.trimToNull(relativeLocationPattern), "locationPattern", new Object[0]);
    }
}

