/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.export;

import com.alibaba.citrus.logconfig.LogConfigurator;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.export.SchemaExporter;
import com.alibaba.citrus.util.Assert;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class SchemaExporterCLI
extends SchemaExporter {
    public static void main(String[] args) throws IOException {
        File destdir = null;
        String uriPrefix = null;
        boolean debug = false;
        boolean toMoreArgs = false;
        for (String arg : args) {
            if ("-debug".equals(arg)) {
                debug = true;
                continue;
            }
            if (destdir == null) {
                destdir = new File(arg);
                continue;
            }
            if (uriPrefix == null) {
                uriPrefix = arg;
                continue;
            }
            toMoreArgs = true;
        }
        if (destdir == null || toMoreArgs) {
            System.err.println("Usage: SchemaExport [-debug] <directoryToExport> [uriPrefix]");
            System.exit(1);
        }
        LogConfigurator.getConfigurator().configureDefault(debug);
        SchemaExporterCLI exporter = new SchemaExporterCLI();
        if (uriPrefix == null || uriPrefix.length() == 0) {
            exporter.saveTo(destdir);
        } else {
            exporter.saveTo(destdir, uriPrefix);
        }
    }

    public SchemaExporterCLI() {
    }

    public SchemaExporterCLI(Schemas ... schemasList) {
        super(schemasList);
    }

    public void saveTo(File dir) throws IOException {
        this.saveTo(dir, dir.toURI().toString());
    }

    public void saveTo(File dir, String uriPrefix) throws IOException {
        if (uriPrefix == null) {
            this.log.info("Saving schema to directory: {}", (Object)dir.getAbsolutePath());
        } else {
            this.log.info("Saving schema to directory: \"{}\", with prefix: \"{}\"", (Object)dir.getAbsolutePath(), (Object)uriPrefix);
        }
        this.saveTo(dir, this.getRootEntry(), uriPrefix);
    }

    private void saveTo(File file, SchemaExporter.Entry entry, String uriPrefix) throws IOException {
        Assert.assertNotNull(file, "file", new Object[0]);
        if (entry.isDirectory()) {
            if (!file.exists()) {
                file.mkdirs();
                this.log.debug("mkdir {}", (Object)file.getAbsolutePath());
            }
            if (!file.isDirectory() || !file.canWrite()) {
                throw new IOException("Exporting target is not a writable directory: " + file.getAbsolutePath());
            }
            for (SchemaExporter.Entry subEntry : entry.getSubEntries()) {
                this.saveTo(new File(file, subEntry.getName()), subEntry, uriPrefix);
            }
        } else {
            this.log.debug("Writing file: {}", (Object)file.getAbsolutePath());
            this.writeTo(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), entry, "UTF-8", uriPrefix);
        }
    }
}

