/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.export;

import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.support.SchemaSet;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.springext.support.SpringExtSchemaSet;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.StreamUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Entries entries = new Entries();
    private final SchemaSet schemas;

    public SchemaExporter() {
        this(new SpringExtSchemaSet());
    }

    public SchemaExporter(Schemas ... schemasList) {
        this.schemas = SchemaSet.getInstance(schemasList);
        for (Schema schema : this.schemas.getNamedMappings().values()) {
            this.entries.put(schema.getName(), new Entry(schema.getName(), schema));
        }
    }

    private Entries getEntries() {
        return this.entries;
    }

    public Entry getRootEntry() {
        return this.getEntries().getRoot();
    }

    public Entry getEntry(String path) {
        return (Entry)this.getEntries().get(path);
    }

    public void writeTo(Writer out, Entry entry, String charset) throws IOException {
        this.writeTo(out, entry, charset, (String)null);
    }

    public void writeTo(Writer out, Entry entry, String charset, String uriPrefix) throws IOException {
        this.writeTo(out, entry, charset, uriPrefix == null ? null : SchemaUtil.getAddPrefixTransformer(this.schemas, uriPrefix));
    }

    private void writeTo(Writer out, Entry entry, String charset, Schema.Transformer transformer) throws IOException {
        StreamUtil.writeText(entry.getSchema().getText(charset, transformer), out, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Entries
    extends HashMap<String, Entry> {
        private static final long serialVersionUID = -4000525580274040823L;

        public Entries() {
            super.put("", new Entry());
        }

        public Entry getRoot() {
            return (Entry)this.get("");
        }

        @Override
        public Entry put(String path, Entry entry) {
            String parentPath;
            Entry parentEntry;
            Assert.assertTrue(path.equals(entry.getPath()));
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((parentEntry = (Entry)this.get(parentPath = path.substring(0, path.lastIndexOf("/") + 1))) == null) {
                parentEntry = new Entry(parentPath);
                this.put(parentPath, parentEntry);
            }
            parentEntry.subEntries.put(entry.getSortKey(), entry);
            Entry old = super.put(entry.getPath(), entry);
            SchemaExporter.this.log.trace("Added entry: {}", (Object)entry.getPath());
            return old;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry {
        private final String path;
        private final String name;
        private final boolean directory;
        private final boolean root;
        private final Schema schema;
        private final Map<String, Entry> subEntries;
        private static final String PREFIX_ITEM = "+---";
        private static final String PREFIX_LAST_ITEM = "\\---";
        private static final String INDENT_BEFORE_LAST_ITEM = "|   ";
        private static final String INDENT_AFTER_LAST_ITEM = "    ";

        private Entry() {
            this.path = "";
            this.name = "";
            this.directory = true;
            this.root = true;
            this.schema = null;
            this.subEntries = CollectionUtil.createTreeMap();
        }

        public Entry(String path) {
            this(path, null);
        }

        public Entry(String path, Schema schema) {
            this.path = Assert.assertNotNull(StringUtil.trimToNull(path), "path", new Object[0]);
            this.directory = path.endsWith("/");
            int fromIndex = this.directory ? path.length() - 2 : path.length();
            this.name = path.substring(path.lastIndexOf("/", fromIndex) + 1);
            this.root = false;
            this.schema = schema;
            this.subEntries = CollectionUtil.createTreeMap();
            if (this.directory) {
                Assert.assertNull(schema, "schema", new Object[0]);
            } else {
                Assert.assertNotNull(schema, "schema", new Object[0]);
            }
        }

        public String getPath() {
            return this.path;
        }

        public String getId() {
            if (this.isRoot()) {
                return "ROOT";
            }
            return this.path.replaceFirst("\\.[^-\\./]*$|/+$", "").replace('/', '-').replace('.', '-');
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public boolean isRoot() {
            return this.root;
        }

        public Collection<Entry> getSubEntries() {
            return this.subEntries.values();
        }

        public Schema getSchema() {
            return this.schema;
        }

        public boolean containsSchemaWithTargetNamespace() {
            boolean hasNs = false;
            if (this.isDirectory()) {
                for (Entry subEntry : this.getSubEntries()) {
                    if (!subEntry.containsSchemaWithTargetNamespace()) continue;
                    hasNs = true;
                    break;
                }
            } else if (this.getSchema() != null) {
                hasNs = this.getSchema().getTargetNamespace() != null;
            }
            return hasNs;
        }

        public String tree() {
            StringWriter sw = new StringWriter();
            try {
                this.tree(sw);
            }
            catch (IOException e) {
                Assert.unexpectedException(e);
            }
            return sw.toString();
        }

        public void tree(Appendable buf) throws IOException {
            this.tree(buf, "");
        }

        public void tree(Appendable buf, String prefix) throws IOException {
            this.tree(buf, prefix, prefix);
        }

        private void tree(Appendable buf, String prefix, String indent) throws IOException {
            buf.append(prefix).append(this.getName()).append("\n");
            Iterator<Entry> i = this.subEntries.values().iterator();
            while (i.hasNext()) {
                String subIndent;
                String subPrefix;
                Entry subEntry = i.next();
                if (i.hasNext()) {
                    subPrefix = indent + PREFIX_ITEM;
                    subIndent = indent + INDENT_BEFORE_LAST_ITEM;
                } else {
                    subPrefix = indent + PREFIX_LAST_ITEM;
                    subIndent = indent + INDENT_AFTER_LAST_ITEM;
                }
                subEntry.tree(buf, subPrefix, subIndent);
            }
        }

        private String getSortKey() {
            String name = this.getName();
            if (!this.isDirectory()) {
                int dotIndex;
                int slashIndex = name.lastIndexOf("/");
                if (slashIndex < (dotIndex = name.lastIndexOf(".")) && dotIndex >= 0) {
                    return "0-" + name.substring(0, dotIndex);
                }
                return "0-" + name;
            }
            return "1-" + name;
        }

        public String toString() {
            return this.root ? "/" : this.path;
        }
    }
}

