/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.velocity.impl;

import com.alibaba.citrus.service.velocity.impl.AbstractResourceLoader;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import org.apache.commons.collections.ExtendedProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringResourceLoaderAdapter
extends AbstractResourceLoader {
    public static final String SPRING_RESOURCE_LOADER_KEY = "_spring_resource_loader";
    private String path;
    private ResourceLoader springLoader;

    public void init(ExtendedProperties configuration) {
        this.rsvc.getLog().info((Object)(this.getLogID() + " : initialization starting."));
        this.springLoader = Assert.assertNotNull((ResourceLoader)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER_KEY), SPRING_RESOURCE_LOADER_KEY, new Object[0]);
        this.path = FileUtil.normalizeAbsolutePath(configuration.getString("path"), true);
        Assert.assertTrue(!StringUtil.isEmpty(this.path), "path", new Object[0]);
        this.path = this.path + "/";
        this.rsvc.getLog().info((Object)(this.getLogID() + " : set path '" + this.path + "'"));
        this.rsvc.getLog().info((Object)(this.getLogID() + " : initialization complete."));
    }

    protected Resource getResource(String templateName) {
        return this.springLoader.getResource(this.path + this.normalizeTemplateName(templateName));
    }

    protected String getLogID() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getDesc() {
        return this.path;
    }
}

