/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.velocity.impl;

import com.alibaba.citrus.util.Assert;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;

public class Slf4jLogChute
implements LogChute {
    private final Logger log;

    public Slf4jLogChute(Logger log) {
        this.log = Assert.assertNotNull(log, "log", new Object[0]);
    }

    public void init(RuntimeServices rs) throws Exception {
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable t) {
        switch (level) {
            case -1: 
            case 0: 
            case 1: {
                if (t == null) break;
                if (message == null) {
                    message = t.getMessage();
                    t = null;
                    break;
                }
                message = message + ": " + t.getMessage();
                t = null;
                break;
            }
        }
        switch (level) {
            case -1: {
                this.log.trace(message, t);
                break;
            }
            case 0: {
                this.log.debug(message, t);
                break;
            }
            case 1: {
                this.log.info(message, t);
                break;
            }
            case 2: {
                this.log.warn(message, t);
                break;
            }
            case 3: {
                this.log.error(message, t);
                break;
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        switch (level) {
            case -1: {
                return this.log.isTraceEnabled();
            }
            case 0: {
                return this.log.isDebugEnabled();
            }
            case 1: {
                return this.log.isInfoEnabled();
            }
            case 2: {
                return this.log.isWarnEnabled();
            }
            case 3: {
                return this.log.isErrorEnabled();
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.log.getName() + "]";
    }
}

