/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.velocity.impl;

import com.alibaba.citrus.service.template.TemplateException;
import com.alibaba.citrus.service.velocity.FastCloneable;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.ContextAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneableEventCartridge
extends EventCartridge {
    private static final Logger log = LoggerFactory.getLogger(CloneableEventCartridge.class);
    private static final Method cloneMethod = CloneableEventCartridge.getCloneMethod();
    private final List<EventHandler> allHandlers = CollectionUtil.createLinkedList();
    private boolean initialized;
    private boolean needsClone = false;

    private static Method getCloneMethod() {
        Method method = null;
        try {
            method = Object.class.getDeclaredMethod("clone", new Class[0]);
            method.setAccessible(true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return method;
    }

    public void initOnce(RuntimeServices rs) throws Exception {
        if (!this.initialized) {
            super.initialize(rs);
            this.initialized = true;
        }
    }

    public void initialize(RuntimeServices rs) throws Exception {
        Assert.assertTrue(this.initialized, Assert.ExceptionType.ILLEGAL_STATE, "not initialized yet", new Object[0]);
    }

    public boolean addEventHandler(EventHandler ev) {
        boolean supported = super.addEventHandler(ev);
        if (supported) {
            this.allHandlers.add(ev);
            if (ev instanceof ContextAware) {
                this.needsClone = true;
                if (!(ev instanceof FastCloneable)) {
                    if (ev instanceof Cloneable) {
                        log.warn("EventHandler which implements ContextAware and Cloneable may slow down the velocity rendering process: {}", (Object)ev.getClass().getName());
                    } else {
                        throw new IllegalArgumentException("EventHandler which implements ContextAware should also implements FastCloneable or Cloneable: " + ev.getClass().getName());
                    }
                }
            }
        }
        return supported;
    }

    public EventCartridge getRuntimeInstance() {
        CloneableEventCartridge runtimeInstance = this;
        if (this.needsClone) {
            runtimeInstance = new EventCartridge();
            for (EventHandler ev : this.allHandlers) {
                if (ev instanceof ContextAware) {
                    if (ev instanceof FastCloneable) {
                        ev = (EventHandler)((FastCloneable)ev).createCopy();
                    } else {
                        try {
                            ev = (EventHandler)cloneMethod.invoke((Object)ev, new Object[0]);
                        }
                        catch (Exception e) {
                            throw new TemplateException("Could not clone a ContextAware event handler: " + ev.getClass().getName(), e);
                        }
                    }
                }
                runtimeInstance.addEventHandler(ev);
            }
        }
        return runtimeInstance;
    }
}

