/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.velocity.impl;

import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.springframework.core.io.Resource;

public abstract class AbstractResourceLoader
extends ResourceLoader {
    public final InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        Resource resource = this.getResource(templateName);
        IOException exception = null;
        if (resource != null && resource.exists()) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                exception = e;
            }
        }
        throw new ResourceNotFoundException(this.getLogID() + " Error: could not find template: " + templateName, (Throwable)exception);
    }

    public final boolean isSourceModified(org.apache.velocity.runtime.resource.Resource templateResource) {
        long lastModified;
        Resource resource = this.getResource(templateResource.getName());
        if (resource == null || !resource.exists()) {
            return true;
        }
        try {
            lastModified = resource.lastModified();
        }
        catch (IOException e) {
            lastModified = 0L;
        }
        if (lastModified <= 0L) {
            return false;
        }
        return lastModified != templateResource.getLastModified();
    }

    public final long getLastModified(org.apache.velocity.runtime.resource.Resource templateResource) {
        Resource resource = this.getResource(templateResource.getName());
        if (resource != null && resource.exists()) {
            try {
                return resource.lastModified();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0L;
    }

    protected final String normalizeTemplateName(String templateName) {
        if (StringUtil.isEmpty(templateName)) {
            throw new ResourceNotFoundException("Need to specify a template name!");
        }
        if (templateName.startsWith("/")) {
            templateName = templateName.substring(1);
        }
        return templateName;
    }

    protected abstract Resource getResource(String var1);

    public boolean resourceExists(String resourceName) {
        Resource resource = this.getResource(resourceName);
        return resource != null && resource.exists();
    }

    protected abstract String getLogID();

    protected abstract String getDesc();

    public String toString() {
        return this.getLogID() + "[" + this.getDesc() + "]";
    }
}

