/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.interceptor;

import com.alibaba.citrus.service.uribroker.interceptor.URIBrokerPathInterceptor;
import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Random;
import java.util.regex.Pattern;

public class Randomize
implements URIBrokerPathInterceptor {
    private static final String DEFAULT_CHARS = "0123456789abcdefghijklmnopqrstuvwxyz";
    private static final String DEFAULT_KEY = "r";
    private static final long DEFAULT_RANGE = 100000L;
    private final Random random = new Random();
    private boolean initialized;
    private String path;
    private Pattern pathPattern;
    private char[] chars;
    private int radix;
    private double factor;
    private String key;

    public void setKey(String key) {
        this.key = ObjectUtil.defaultIfNull(StringUtil.trimToNull(key), DEFAULT_KEY);
    }

    public void setChars(String chars) {
        this.chars = ObjectUtil.defaultIfNull(StringUtil.trimToNull(chars), DEFAULT_CHARS).toCharArray();
        this.radix = this.chars.length;
    }

    public void setRange(long range) {
        if (range == 0L) {
            range = 100000L;
        }
        this.factor = Math.abs((double)range / 9.223372036854776E18);
    }

    public void setPath(String path) {
        this.path = StringUtil.trimToNull(path);
    }

    void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.chars == null) {
            this.setChars(null);
        }
        if (this.factor == 0.0) {
            this.setRange(0L);
        }
        if (this.key == null) {
            this.setKey(null);
        }
        if (this.path != null && this.pathPattern == null) {
            this.pathPattern = Pattern.compile(this.path);
        }
    }

    public void perform(URIBroker broker) {
    }

    public String perform(URIBroker broker, String path) {
        this.init();
        if (this.pathPattern == null || this.pathPattern.matcher(path).matches()) {
            broker.setQueryData(this.key, this.longToString(this.random()));
        }
        return path;
    }

    protected final long random() {
        return (long)((double)Math.abs(this.random.nextLong()) * this.factor);
    }

    protected final String longToString(long longValue) {
        if (longValue == 0L) {
            return String.valueOf(this.chars[0]);
        }
        if (longValue < 0L) {
            longValue = -longValue;
        }
        StringBuilder strValue = new StringBuilder();
        while (longValue != 0L) {
            int digit = (int)(longValue % (long)this.radix);
            longValue /= (long)this.radix;
            strValue.append(this.chars[digit]);
        }
        return strValue.reverse().toString();
    }
}

