/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.template.impl;

import com.alibaba.citrus.service.template.impl.TemplateServiceImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateServiceDefinitionParser
extends AbstractNamedBeanDefinitionParser<TemplateServiceImpl>
implements ContributionAware {
    private ConfigurationPoint templateEnginesConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.templateEnginesConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/template/engines", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
        Map<Object, Object> engines = SpringExtUtil.createManagedMap(element, parserContext);
        Map<Object, Object> mappings = SpringExtUtil.createManagedMap(element, parserContext);
        DomUtil.ElementSelector engineSelector = DomUtil.ns(this.templateEnginesConfigurationPoint.getNamespaceUri());
        DomUtil.ElementSelector mappingSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("template-mapping"));
        for (Element subElement : DomUtil.subElements(element)) {
            if (engineSelector.accept(subElement)) {
                BeanDefinitionHolder engine = SpringExtUtil.parseConfigurationPointBean(subElement, this.templateEnginesConfigurationPoint, parserContext, builder);
                engines.put(engine.getBeanName(), engine);
                continue;
            }
            if (!mappingSelector.accept(subElement)) continue;
            String ext = FileUtil.normalizeExtension(subElement.getAttribute("extension"));
            String engineName = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("engine")), "engine", new Object[0]);
            Assert.assertNotNull(ext, "extension", new Object[0]);
            Assert.assertTrue(!mappings.containsKey(ext), "duplicated extension: %s", ext);
            mappings.put(ext, engineName);
        }
        builder.addPropertyValue("engines", engines);
        builder.addPropertyValue("engineNameMappings", mappings);
        SpringExtUtil.attributesToProperties(element, builder, "defaultExtension", "searchExtensions", "searchLocalizedTemplates", "cacheEnabled");
    }

    @Override
    protected String getDefaultName() {
        return "templateService";
    }
}

