/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.impl;

import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.PathNameWildcardCompiler;
import java.util.regex.Pattern;

abstract class ResourcePattern {
    private ResourceLoadingService resourceLoadingService;
    private String patternName;
    private Pattern pattern;
    private int relevancy;

    ResourcePattern() {
    }

    public ResourceLoadingService getResourceLoadingService() {
        return this.resourceLoadingService;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public abstract String getPatternType();

    public String getPatternName() {
        return this.patternName;
    }

    public void setPatternName(String patternName) {
        this.patternName = StringUtil.trimToEmpty(patternName);
    }

    public int getRelevancy() {
        return this.relevancy;
    }

    public boolean isRelativePattern() {
        return !this.patternName.startsWith("/");
    }

    public final void init(ResourceLoadingService resourceLoadingService) {
        this.pattern = PathNameWildcardCompiler.compilePathName(this.patternName);
        this.relevancy = PathNameWildcardCompiler.getPathNameRelevancy(this.patternName);
        this.resourceLoadingService = Assert.assertNotNull(resourceLoadingService, "resourceLoadingService", new Object[0]);
        this.init();
    }

    protected abstract void init();
}

