/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.impl;

import com.alibaba.citrus.service.resource.impl.ResourceAlias;
import com.alibaba.citrus.service.resource.impl.ResourceFilterMapping;
import com.alibaba.citrus.service.resource.impl.ResourceLoaderMapping;
import com.alibaba.citrus.service.resource.impl.ResourceLoadingServiceImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoadingServiceDefinitionParser
extends AbstractNamedBeanDefinitionParser<ResourceLoadingServiceImpl>
implements ContributionAware {
    private ConfigurationPoint loadersConfigurationPoint;
    private ConfigurationPoint filtersConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.loadersConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/resource-loading/loaders", contrib);
        this.filtersConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/resource-loading/filters", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        URL configFileURL;
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
        try {
            configFileURL = parserContext.getReaderContext().getResource().getURL();
        }
        catch (IOException e) {
            configFileURL = null;
        }
        if (configFileURL != null) {
            builder.addPropertyValue("configLocation", (Object)configFileURL);
        }
        DomUtil.ElementSelector resourceSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("resource"));
        DomUtil.ElementSelector resourceAliasSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("resource-alias"));
        DomUtil.ElementSelector resourceFiltersSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("resource-filters"));
        List<Object> resourceMappings = SpringExtUtil.createManagedList(element, parserContext);
        List<Object> filterMappings = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            if (resourceSelector.accept(subElement)) {
                resourceMappings.add(this.parseResource(subElement, parserContext));
                continue;
            }
            if (resourceAliasSelector.accept(subElement)) {
                resourceMappings.add(this.parseAlias(subElement, parserContext));
                continue;
            }
            if (!resourceFiltersSelector.accept(subElement)) continue;
            filterMappings.add(this.parseFilters(subElement, parserContext));
        }
        builder.addPropertyValue("resourceMappings", resourceMappings);
        builder.addPropertyValue("filterMappings", filterMappings);
        String parentRef = StringUtil.trimToNull(element.getAttribute("parentRef"));
        if (parentRef != null) {
            builder.addPropertyValue("parent", (Object)new RuntimeBeanReference(parentRef));
        }
    }

    private BeanDefinition parseResource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder resourceMapping = BeanDefinitionBuilder.genericBeanDefinition(ResourceLoaderMapping.class);
        resourceMapping.addPropertyValue("patternName", (Object)StringUtil.trimToNull(element.getAttribute("pattern")));
        SpringExtUtil.attributesToProperties(element, resourceMapping, "internal");
        List<Object> loaders = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            loaders.add(SpringExtUtil.parseConfigurationPointBean(subElement, this.loadersConfigurationPoint, parserContext, resourceMapping));
        }
        resourceMapping.addPropertyValue("loaders", loaders);
        return resourceMapping.getBeanDefinition();
    }

    private BeanDefinition parseAlias(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder resourceMapping = BeanDefinitionBuilder.genericBeanDefinition(ResourceAlias.class);
        resourceMapping.addPropertyValue("patternName", (Object)StringUtil.trimToNull(element.getAttribute("pattern")));
        SpringExtUtil.attributesToProperties(element, resourceMapping, "internal", "name");
        return resourceMapping.getBeanDefinition();
    }

    private BeanDefinition parseFilters(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder resourceFilterMapping = BeanDefinitionBuilder.genericBeanDefinition(ResourceFilterMapping.class);
        resourceFilterMapping.addPropertyValue("patternName", (Object)StringUtil.trimToNull(element.getAttribute("pattern")));
        List<Object> filters = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            filters.add(SpringExtUtil.parseConfigurationPointBean(subElement, this.filtersConfigurationPoint, parserContext, resourceFilterMapping));
        }
        resourceFilterMapping.addPropertyValue("filters", filters);
        return resourceFilterMapping.getBeanDefinition();
    }

    @Override
    protected String getDefaultName() {
        return "resourceLoadingService";
    }
}

