/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.store.simple.impl;

import com.alibaba.citrus.service.requestcontext.session.SessionConfig;
import com.alibaba.citrus.service.requestcontext.session.SessionStore;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMemoryStoreImpl
implements SessionStore {
    private final ConcurrentMap<String, Map<String, Object>> sessions = CollectionUtil.createConcurrentHashMap();

    @Override
    public void init(String storeName, SessionConfig sessionConfig) {
    }

    public Map<String, Object> getSession(String sessionID) {
        return (Map)this.sessions.get(sessionID);
    }

    @Override
    public Iterable<String> getAttributeNames(String sessionID, SessionStore.StoreContext storeContext) {
        Map sessionData = (Map)this.sessions.get(sessionID);
        if (sessionData == null) {
            return Collections.emptyList();
        }
        return sessionData.keySet();
    }

    @Override
    public Object loadAttribute(String attrName, String sessionID, SessionStore.StoreContext storeContext) {
        Map sessionData = (Map)this.sessions.get(sessionID);
        if (sessionData == null) {
            return null;
        }
        return sessionData.get(attrName);
    }

    @Override
    public void invaldiate(String sessionID, SessionStore.StoreContext storeContext) {
        this.sessions.remove(sessionID);
    }

    @Override
    public void commit(Map<String, Object> modifiedAttrs, String sessionID, SessionStore.StoreContext storeContext) {
        Map<String, Object> sessionData = null;
        if (!this.sessions.containsKey(sessionID)) {
            sessionData = CollectionUtil.createConcurrentHashMap();
            this.sessions.putIfAbsent(sessionID, sessionData);
        }
        sessionData = (Map)this.sessions.get(sessionID);
        Assert.assertNotNull(sessionData, "sessionData for ID: %s", sessionID);
        for (Map.Entry<String, Object> entry : modifiedAttrs.entrySet()) {
            String attrName = entry.getKey();
            Object attrValue = entry.getValue();
            if (attrValue == null) {
                sessionData.remove(attrName);
                continue;
            }
            sessionData.put(attrName, attrValue);
        }
    }

    public String toString() {
        return "SimpleMemoryStore[" + this.sessions.size() + " sessions]";
    }
}

