/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rewrite.impl;

import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.util.regex.MatchResult;
import javax.servlet.http.HttpServletRequest;

public class RewriteUtil {
    public static boolean isFullURL(String path) {
        return path.matches("^\\w+:.*");
    }

    public static MatchResultSubstitution getMatchResultSubstitution(MatchResult ruleMatchResult, MatchResult conditionMatchResult) {
        return new MatchResultSubstitution("$%", ruleMatchResult, conditionMatchResult);
    }

    public static String getSubstitutedTestString(String testString, MatchResult ruleMatchResult, MatchResult conditionMatchResult, HttpServletRequest request) {
        testString = RewriteUtil.eval(testString, request);
        return RewriteUtil.getMatchResultSubstitution(ruleMatchResult, conditionMatchResult).substitute(testString);
    }

    protected static String eval(String expr, HttpServletRequest request) {
        int length = expr.length();
        int startIndex = expr.indexOf("%{");
        if (startIndex < 0) {
            return expr;
        }
        int endIndex = expr.indexOf("}", startIndex + 2);
        if (endIndex < 0) {
            return expr;
        }
        StringBuffer resultBuffer = new StringBuffer();
        StringBuffer charBuffer = new StringBuffer();
        StringBuffer varNameBuffer = new StringBuffer();
        int i = 0;
        block10: while (i < length) {
            char ch = expr.charAt(i);
            block0 : switch (ch) {
                case '%': {
                    if (i + 1 < length) {
                        ch = expr.charAt(++i);
                        switch (ch) {
                            case '%': {
                                charBuffer.append(ch);
                                break;
                            }
                            case '{': {
                                if (charBuffer.length() > 0) {
                                    resultBuffer.append(charBuffer);
                                    charBuffer.setLength(0);
                                }
                                if (i + 1 >= length) break block0;
                                ++i;
                                while (i < length) {
                                    ch = expr.charAt(i);
                                    switch (ch) {
                                        case '}': {
                                            String varName = varNameBuffer.toString();
                                            String varNameExpanded = RewriteUtil.expand(varName, request);
                                            if (varNameExpanded == null) {
                                                resultBuffer.append("%{").append(varName).append("}");
                                            } else {
                                                resultBuffer.append(varNameExpanded);
                                            }
                                            varNameBuffer.setLength(0);
                                            ++i;
                                            continue block10;
                                        }
                                    }
                                    varNameBuffer.append(ch);
                                    ++i;
                                }
                                if (varNameBuffer.length() <= 0) break block0;
                                resultBuffer.append("%{").append(varNameBuffer);
                                break;
                            }
                            default: {
                                charBuffer.append(ch);
                                break;
                            }
                        }
                        break;
                    }
                    charBuffer.append(ch);
                    break;
                }
                default: {
                    charBuffer.append(ch);
                }
            }
            ++i;
        }
        if (charBuffer.length() > 0) {
            resultBuffer.append(charBuffer);
        }
        return resultBuffer.toString();
    }

    private static String expand(String varName, HttpServletRequest request) {
        String result;
        boolean valid = true;
        if ("REMOTE_HOST".equals(varName)) {
            result = request.getRemoteHost();
        } else if ("REMOTE_ADDR".equals(varName)) {
            result = request.getRemoteAddr();
        } else if ("REMOTE_USER".equals(varName)) {
            result = request.getRemoteUser();
        } else if ("REQUEST_METHOD".equals(varName)) {
            result = request.getMethod();
        } else if ("QUERY_STRING".equals(varName)) {
            if ("post".equalsIgnoreCase(request.getMethod())) {
                ParserRequestContext parserRequestContext = RequestContextUtil.findRequestContext(request, ParserRequestContext.class);
                result = parserRequestContext.getParameters().toQueryString();
            } else {
                result = request.getQueryString();
            }
        } else if (varName.startsWith("QUERY:")) {
            ParserRequestContext parserRequestContext = RequestContextUtil.findRequestContext(request, ParserRequestContext.class);
            result = parserRequestContext.getParameters().getString(varName.substring("QUERY:".length()).trim());
        } else if ("AUTH_TYPE".equals(varName)) {
            result = request.getAuthType();
        } else if ("SERVER_NAME".equals(varName)) {
            result = request.getServerName();
        } else if ("SERVER_PORT".equals(varName)) {
            result = String.valueOf(request.getServerPort());
        } else if ("SERVER_PROTOCOL".equals(varName)) {
            result = request.getProtocol();
        } else if ("HTTP_USER_AGENT".equals(varName)) {
            result = request.getHeader("User-Agent");
        } else if ("HTTP_REFERER".equals(varName)) {
            result = request.getHeader("Referer");
        } else if ("HTTP_HOST".equals(varName)) {
            result = request.getHeader("Host");
        } else if ("HTTP_ACCEPT".equals(varName)) {
            result = request.getHeader("Accept");
        } else if ("HTTP_COOKIE".equals(varName)) {
            result = request.getHeader("Cookie");
        } else if ("REQUEST_URI".equals(varName)) {
            result = request.getRequestURI();
        } else {
            result = null;
            valid = false;
        }
        if (valid && result == null) {
            result = "";
        }
        return result;
    }
}

