/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.parser.impl;

import com.alibaba.citrus.service.configuration.support.PropertyEditorRegistrarsSupport;
import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextInfo;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParserFilter;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.parser.impl.ParserRequestContextImpl;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextFactory;
import com.alibaba.citrus.service.upload.UploadService;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import org.springframework.beans.PropertyEditorRegistrar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRequestContextFactoryImpl
extends AbstractRequestContextFactory<ParserRequestContext> {
    private static final boolean CONVERTER_QUIET_DEFAULT = true;
    private static final String URL_CASE_FOLDING_DEFAULT = "lower_with_underscores";
    private static final boolean AUTO_UPLOAD_DEFAULT = true;
    private static final boolean UNESCAPE_PARAMETERS_DEFAULT = true;
    private static final boolean USE_SERVLET_ENGINE_PARSER_DEFAULT = false;
    private static final boolean USE_BODY_ENCODING_FOR_URI_DEFAULT = true;
    private static final String URI_ENCODING_DEFAULT = "UTF-8";
    private static final boolean TRIMMING_DEFAULT = true;
    private static final String HTML_FIELD_SUFFIX_DEFAULT = ".~html";
    private PropertyEditorRegistrarsSupport propertyEditorRegistrars = new PropertyEditorRegistrarsSupport();
    private Boolean converterQuiet;
    private String caseFolding;
    private Boolean autoUpload;
    private Boolean unescapeParameters;
    private Boolean useServletEngineParser;
    private Boolean useBodyEncodingForURI;
    private String uriEncoding;
    private Boolean trimming;
    private ParameterParserFilter[] filters;
    private String htmlFieldSuffix;
    private UploadService uploadService;

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] registrars) {
        this.propertyEditorRegistrars.setPropertyEditorRegistrars(registrars);
    }

    public void setConverterQuiet(boolean converterQuiet) {
        this.converterQuiet = converterQuiet;
    }

    public void setCaseFolding(String caseFolding) {
        this.caseFolding = caseFolding;
    }

    public void setAutoUpload(boolean autoUpload) {
        this.autoUpload = autoUpload;
    }

    public void setUnescapeParameters(boolean unescapeParameters) {
        this.unescapeParameters = unescapeParameters;
    }

    public void setUseServletEngineParser(boolean useServletEngineParser) {
        this.useServletEngineParser = useServletEngineParser;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
    }

    public void setURIEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public void setTrimming(boolean trimming) {
        this.trimming = trimming;
    }

    public void setParameterParserFilters(ParameterParserFilter[] filters) {
        this.filters = filters;
    }

    public void setHtmlFieldSuffix(String htmlFieldSuffix) {
        this.htmlFieldSuffix = htmlFieldSuffix;
    }

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    @Override
    protected void init() {
        this.converterQuiet = ObjectUtil.defaultIfNull(this.converterQuiet, true);
        this.caseFolding = StringUtil.defaultIfEmpty(this.caseFolding, URL_CASE_FOLDING_DEFAULT).toLowerCase();
        this.autoUpload = ObjectUtil.defaultIfNull(this.autoUpload, true);
        this.unescapeParameters = ObjectUtil.defaultIfNull(this.unescapeParameters, true);
        this.useServletEngineParser = ObjectUtil.defaultIfNull(this.useServletEngineParser, false);
        this.useBodyEncodingForURI = ObjectUtil.defaultIfNull(this.useBodyEncodingForURI, true);
        this.uriEncoding = ObjectUtil.defaultIfNull(this.uriEncoding, URI_ENCODING_DEFAULT);
        this.trimming = ObjectUtil.defaultIfNull(this.trimming, true);
        this.htmlFieldSuffix = StringUtil.defaultIfEmpty(this.htmlFieldSuffix, HTML_FIELD_SUFFIX_DEFAULT);
    }

    @Override
    public ParserRequestContext getRequestContextWrapper(RequestContext wrappedContext) {
        ParserRequestContextImpl requestContext = new ParserRequestContextImpl(wrappedContext);
        requestContext.setPropertyEditorRegistrar(this.propertyEditorRegistrars);
        requestContext.setConverterQuiet(this.converterQuiet);
        requestContext.setAutoUpload(this.autoUpload);
        requestContext.setCaseFolding(this.caseFolding);
        requestContext.setUnescapeParameters(this.unescapeParameters);
        requestContext.setUseServletEngineParser(this.useServletEngineParser);
        requestContext.setUseBodyEncodingForURI(this.useBodyEncodingForURI);
        requestContext.setURIEncoding(this.uriEncoding);
        requestContext.setTrimming(this.trimming);
        if (this.autoUpload.booleanValue()) {
            requestContext.setUploadService(this.uploadService);
        }
        if (!ArrayUtil.isEmptyArray(this.filters)) {
            requestContext.setParameterParserFilters(this.filters);
        }
        requestContext.setHtmlFieldSuffix(this.htmlFieldSuffix);
        return requestContext;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"parseRequest"};
    }

    @Override
    public RequestContextInfo.FeatureOrder[] featureOrders() {
        return null;
    }

    @Override
    protected Object dumpConfiguration() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("Converter quiet", this.converterQuiet);
        mb.append("Case folding", this.caseFolding);
        mb.append("Auto upload", this.autoUpload);
        mb.append("Unescape HTML entities", this.unescapeParameters);
        mb.append("Use servlet engine's parser", this.useServletEngineParser);
        mb.append("Use body encoding for URI", this.useBodyEncodingForURI);
        mb.append("URI encoding if not use body encoding for URI", this.uriEncoding);
        mb.append("Trimming", this.trimming);
        mb.append("HTML field suffix", this.htmlFieldSuffix);
        mb.append("Upload Service", this.uploadService);
        mb.append("Parameter Parser Filters", this.filters);
        return mb;
    }
}

